(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    521688,      11441]
NotebookOptionsPosition[    511603,      11199]
NotebookOutlinePosition[    512735,      11238]
CellTagsIndexPosition[    512692,      11235]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        SuperscriptBox["a", "2"]}], "=", 
       SuperscriptBox["b", "2"]}]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.5132751524684167`*^9, 
   3.5132751524684167`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[Cell[TextData[StyleBox["Domain Map ",
   FontSize->24]], "Title",
   CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
     3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
     3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
   TextAlignment->Center,
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"],
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.508727955943869*^9, {
   3.5087281208361588`*^9, 3.5087281279809713`*^9}, {3.5087811392187877`*^9, 
   3.5087811399587884`*^9}, {3.5087812182888985`*^9, 
   3.5087812191188993`*^9}, {3.50989505179342*^9, 3.5098950847434664`*^9}, {
   3.510585688098961*^9, 3.510585693578969*^9}, {3.511370195524361*^9, 
   3.511370201052677*^9}, {3.512153982992205*^9, 3.5121539832322054`*^9}, 
   3.513293185958044*^9, {3.5138009090019484`*^9, 3.5138009178104525`*^9}, 
   3.514736930094408*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], RectangleBox[{-4, 0}, {-1, 4}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 1 \[LowerRightArrow]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-5, 2], 2.5}, {-2.5, 2.5}]]}, 
   {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
    LineBox[{{-1.02, 3.98}, {-1.02, 0.02}}], 
    {RGBColor[0.7, 0.7, 1.], Dashing[{}], RectangleBox[{-1, 0}, {0, 4}], 
     {GrayLevel[0], InsetBox[
       StyleBox["\<\"Rule 2 \[DownArrow]\"\>",
        StripOnInput->False,
        FontSize->10], NCache[{Rational[-1, 2], 2.5}, {-0.5, 2.5}]]}, 
     {RGBColor[0, 1, 0], RectangleBox[{0, -1.02}, {4, 4}]}, 
     {GrayLevel[0], InsetBox[
       StyleBox["\<\"Rule 3 \[LeftArrow]\"\>",
        StripOnInput->False,
        FontSize->10], {2, 2.5}]}, 
     {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
      LineBox[{{0.02, -0.98}, {3.98, -0.98}}], 
      {RGBColor[1, 0.5, 0.5], Dashing[{}], RectangleBox[{0, -1}, {4, -4}], 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 4 \[UpperLeftArrow]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{2, Rational[-5, 2]}, {2, -2.5}]]}, 
       {RGBColor[1, 0, 1], RectangleBox[{-1, -4}, {0, -1.02}]}, 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 5 \[UpArrow]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{Rational[-1, 2], -2.5}, {-0.5, -2.5}]]}, 
       {RGBColor[1, 0.5, 0], RectangleBox[{-4, -4}, {-1, 0}]}, 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 6 \[RightArrow]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{Rational[-5, 2], -2.5}, {-2.5, -2.5}]]}, 
       {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
        LineBox[{{-1.02, 0}, {-1.02, -3.98}}]}, 
       {RGBColor[0, 1, 0], Thickness[Large], Dashing[{}], 
        LineBox[{{-3.98, 0}, {-1, 0}}], 
        {GrayLevel[0], InsetBox[
          StyleBox["\<\"Rule 7 \[RightArrow]\[Diamond]\"\>",
           StripOnInput->False,
           FontSize->10], {-3, 0.13}]}, 
        {RGBColor[1, 0, 0], Thickness[Large], 
         LineBox[{{-0.98, 0}, {3.98, 0}}], 
         {GrayLevel[0], InsetBox[
           StyleBox["\<\"Rule 8\[Diamond]\"\>",
            StripOnInput->False,
            FontSize->10], {2, 0.13}]}, 
         {RGBColor[1, 1, 0], Thickness[Large], LineBox[{{-1, -1}, {2, -4}}], 
          {GrayLevel[0], GeometricTransformationBox[InsetBox[
             StyleBox["\<\"Rule 11 \[UpperLeftArrow]\[Diamond]\"\>",
              StripOnInput->False,
              FontSize->10], {1.6, -3.39}], {{{0.7071067811865475, 
             0.7071067811865475}, {-0.7071067811865475, 0.7071067811865475}}, 
             Center}]}, 
          {RGBColor[0, 0, 1], Thickness[Large], 
           LineBox[{{-4, 2}, {-1.02, -1}}], 
           {GrayLevel[0], GeometricTransformationBox[InsetBox[
              StyleBox["\<\"Rule 12 \[UpperRightArrow]\[Diamond]\"\>",
               StripOnInput->False,
               FontSize->10], {-2.5, 0.7}], {{{0.7071067811865475, 
              0.7071067811865475}, {-0.7071067811865475, 0.7071067811865475}},
               Center}]}, 
           {RGBColor[0, 1, 0], Thickness[Large], 
            LineBox[NCache[{{Rational[1, 2], -1.02}, {
               Rational[1, 2], -3.98}}, {{0.5, -1.02}, {0.5, -3.98}}]], 
            {GrayLevel[0], GeometricTransformationBox[InsetBox[
               StyleBox["\<\" Rule 9 \[LeftArrow]\[Diamond]\"\>",
                StripOnInput->False,
                FontSize->10], {0.65, -3.4}], {{{0, 1}, {-1, 0}}, Center}]}, 
            {RGBColor[1, 0.5, 0], Thickness[Large], 
             LineBox[NCache[{{Rational[1, 2], 3.98}, {
                Rational[1, 2], -0.98}}, {{0.5, 3.98}, {0.5, -0.98}}]], 
             {GrayLevel[0], GeometricTransformationBox[InsetBox[
                StyleBox["\<\"Rule 10\[Diamond]\"\>",
                 StripOnInput->False,
                 FontSize->10], {0.65, 1.5}], {{{0, 1}, {-1, 0}}, Center}]}, 
             {RGBColor[0, 1, 1], DiskBox[{-1, 0}, Scaled[Rational[1, 60]]]}, 
             {GrayLevel[0], InsetBox["\<\"a\"\>", {-0.99, 0}]}, 
             {RGBColor[0, 1, 1], 
              DiskBox[NCache[{Rational[-1, 2], 0}, {-0.5, 0}], Scaled[
               Rational[1, 60]]]}, 
             {GrayLevel[0], InsetBox["\<\"b\"\>", {-0.49, 0}]}, 
             {RGBColor[0, 1, 1], 
              DiskBox[NCache[{Rational[-1, 2], -1}, {-0.5, -1}], Scaled[
               Rational[1, 60]]]}, 
             {GrayLevel[0], InsetBox["\<\"c\"\>", {-0.49, -1}]}, 
             {RGBColor[0, 1, 1], 
              DiskBox[NCache[{
                Rational[-1, 2], Rational[-1, 2]}, {-0.5, -0.5}], Scaled[
               Rational[1, 60]]]}, 
             {GrayLevel[0], 
              InsetBox["\<\"d\"\>", 
               NCache[{-0.49, Rational[-1, 2]}, {-0.49, -0.5}]]}, 
             {GrayLevel[0], 
              DiskBox[{-1, 1}, Scaled[Rational[1, 120]]]}}}}}}}}}}}},
  Axes->True,
  AxesLabel->{
    FormBox["n", TraditionalForm], 
    FormBox[
     RowBox[{"j", " ", "k", " ", "m"}], TraditionalForm]},
  ImageSize->Medium]], "Input",
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["Legend:",
  FontWeight->"Bold"],
 "\n\[Bullet]  The rule number in a colored region indicates the rule to use \
for integrals in that region.\n\[Bullet]  The rule number next to a colored \
line indicates the rule to use for integrals on that line.\n\[Bullet]  A \
white region or line indicates there is no rule for integrals in that region \
or on that line.\n\[Bullet]  A solid black line indicates integrals on that \
line are handled by rules in another section.\n\[Bullet]  A dashed black line \
on the border of a region indicates integrals on that border are handled by \
the rule for that region.\n\[Bullet]  The arrow(s) following a rule number \
indicates the direction the rule drives integrands in the n\[Cross]m exponent \
plane.\n\[Bullet]  A \[Diamond] following a rule number indicates the rule \
transforms the integrand into a form handled by another section.\n\[Bullet]  \
A red (stop) disk indicates the terminal rule to use for the point at the \
center of the disk.\n\[Bullet]  A cyan disk indicates the non-terminal rule \
to use for the point at the center of the disk."
}], "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvWx2qt8BmVeOAtpmKSBazPxXBoguPqZWAKJ3VvSW
gGje1yvrQXTvPN4WEL3DULwVRHNs1u0G0VVfRSeD6EsSC6eD6FV9WrNAtOHV
+HkgWv9Q6k4QHetWuh9EH7w48QCIdohIPgqin689BaaXtdWcBdEb3DovgOjl
RslXQHQI+4X7IPr7BK7nINq2WwJMfxN6/hpEt0g2vAfRR7xefgbRXudamA4C
6WcX4tlBtAzPSx4QbVPAJwSir/yqkwLROQtY5EG0j6SgFohmi8k0AdH7HrBZ
gOjD1z65gOiAl39dQfTDAstoEB2x+BuY7v4bmg6i5+RVgWkAeVypcw==
  "],
 FontSize->14],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["k", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["a", "2"]}], "=", 
      SuperscriptBox["b", "2"]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.510419516272189*^9, 
   3.5104195312022095`*^9}, {3.51344405045832*^9, 3.513444050888321*^9}, 
   3.514736994241721*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["a",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, {
   3.512256142654321*^9, 3.512256144947525*^9}, {3.5122561871143994`*^9, 
   3.512256229733674*^9}, {3.5144137669500422`*^9, 3.514413768119109*^9}, {
   3.5144144744945116`*^9, 3.5144144750495434`*^9}, 3.514737717221733*^9, {
   3.515186697169033*^9, 3.5151867003190374`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}, {
   3.51198092332861*^9, 3.5119809284639034`*^9}, {3.513609260172001*^9, 
   3.513609261622803*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox["A", "a"], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], ")"}], "z"}], 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.510456932005166*^9, 3.510456936635173*^9}, {
   3.5136092874564486`*^9, 3.5136093125100927`*^9}}],

Cell[TextData[{
 "Note: The rule for integrands of the same form when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 " could subsume this rule, but the resulting antiderivative will look less \
like the integrand involving sines instead of cosecants."
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}, {
   3.51198092332861*^9, 3.5119809284639034`*^9}, {3.513609260172001*^9, 
   3.513609261622803*^9}, {3.5147594629917507`*^9, 3.514759580281915*^9}, {
   3.5147596147519636`*^9, 3.5147597089720955`*^9}, {3.514759751312155*^9, 
   3.5147598248822575`*^9}, 3.514760097022639*^9}],

Cell[TextData[{
 "Rule a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, {
   3.4979894880299215`*^9, 3.4979894894339237`*^9}, {3.5043655322225885`*^9, 
   3.50436553318259*^9}, 3.5043711377624407`*^9, 3.504469700248499*^9, 
   3.504986690178133*^9, {3.5104560807139745`*^9, 3.5104560807139745`*^9}, {
   3.5104568937951126`*^9, 3.5104568953851147`*^9}, {3.510505219757546*^9, 
   3.5105052199759464`*^9}, {3.512254387989639*^9, 3.5122543889880404`*^9}, 
   3.512255731234799*^9, {3.5122561484263315`*^9, 3.512256149221933*^9}, {
   3.5122563619439063`*^9, 3.512256362614708*^9}, {3.5147372239989243`*^9, 
   3.514737226838129*^9}, 3.5147377232117414`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"A", " ", "x"}], "a"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979862492990327`*^9, 
   3.4979862502662344`*^9}, {3.497987000218752*^9, 3.4979870022311554`*^9}, {
   3.5053446902338524`*^9, 3.5053446902338524`*^9}, {3.509895243243688*^9, 
   3.5098952441236897`*^9}, {3.510456131784046*^9, 3.5104561346040497`*^9}, {
   3.5104567717849417`*^9, 3.510456808194993*^9}, {3.511980873398754*^9, 
   3.5119809155401645`*^9}, {3.513609169847842*^9, 3.5136092275679436`*^9}, {
   3.5151866702689953`*^9, 3.515186689139022*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"x", "/", "a"}]}], " ", "-", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5053446902438526`*^9, 3.5053446902538524`*^9}, {3.509895249233697*^9, 
   3.5098952515737*^9}, 3.509897436117895*^9, 3.5104305387476435`*^9, 
   3.5104337771841784`*^9, {3.510456046673927*^9, 3.510456071713962*^9}, {
   3.51045684185504*^9, 3.5104568751650867`*^9}, 3.5104570887053857`*^9, 
   3.510505800967767*^9, {3.51050583687903*^9, 3.5105058468630476`*^9}, {
   3.511980955100427*^9, 3.5119809773386993`*^9}, 3.511981056695238*^9, 
   3.512256347513881*^9, 3.513046627978034*^9, 3.513609526136868*^9, {
   3.513609954837514*^9, 3.5136099644775276`*^9}, 3.5147343498990746`*^9, {
   3.5147371951388736`*^9, 3.5147372003492827`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "13"}], "-", "14"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.497986248409831*^9, 
   3.497986248831032*^9}, {3.498495555818041*^9, 3.4984955663948593`*^9}, {
   3.498673619942603*^9, 3.498673628882616*^9}, {3.498673758742798*^9, 
   3.4986737649728065`*^9}, {3.5023763566098824`*^9, 3.502376360556689*^9}, {
   3.5025030477127104`*^9, 3.502503050973116*^9}, {3.5044889589640827`*^9, 
   3.5044889627240877`*^9}, {3.504489536504891*^9, 3.504489565954932*^9}, {
   3.504634739970751*^9, 3.5046347423007536`*^9}, {3.504638584496133*^9, 
   3.504638585126134*^9}, {3.513310686057351*^9, 3.5133106906125593`*^9}, {
   3.513655825388812*^9, 3.5136558272388153`*^9}, {3.5136571788207073`*^9, 
   3.513657179010708*^9}, {3.513796243778113*^9, 3.5137962540497007`*^9}, {
   3.514737623951603*^9, 3.5147376277016077`*^9}, {3.515186740699094*^9, 
   3.5151867423090963`*^9}, {3.516582405611928*^9, 3.5165824124919376`*^9}, {
   3.516592683412245*^9, 3.5165926862822485`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 6 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.5011791668716116`*^9, 3.5011791710116177`*^9}, 
   3.501353556186415*^9, 3.5016214692348776`*^9, 3.5016217325129366`*^9, 
   3.5016376478515205`*^9, {3.513654568447053*^9, 3.513654568657053*^9}, {
   3.51365523818799*^9, 3.5136552967580724`*^9}, {3.513655533898404*^9, 
   3.513655550028427*^9}, {3.5136556344485455`*^9, 3.5136556423385563`*^9}, {
   3.513655708618649*^9, 3.5136557097386503`*^9}, {3.513885178094446*^9, 
   3.513885189374462*^9}}],

Cell[TextData[{
 "Rule 13: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.513655796338772*^9, 
   3.5136557985087748`*^9}, {3.5136563725995784`*^9, 3.51365637363958*^9}, {
   3.5165824178819447`*^9, 3.516582418481946*^9}, {3.516592688692252*^9, 
   3.5165926892922525`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], " ", 
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Csc", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["b", "2"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "A", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.5095533946779337`*^9, 3.509553415627963*^9}, {3.509553538668135*^9, 
   3.5095535518681536`*^9}, {3.5095535889582057`*^9, 
   3.5095536266082582`*^9}, {3.5101725552067585`*^9, 
   3.5101725573127623`*^9}, {3.5101728674101067`*^9, 
   3.5101728711385136`*^9}, {3.510173662715104*^9, 3.510173677129529*^9}, 
   3.5102536435885286`*^9, {3.513292062852798*^9, 3.513292242867111*^9}, {
   3.5132923801169157`*^9, 3.5132923861569242`*^9}, {3.51365561653852*^9, 
   3.513655619968525*^9}, {3.513655650858568*^9, 3.5136557425986967`*^9}, {
   3.5136561182092223`*^9, 3.51365612402923*^9}, {3.515186764559128*^9, 
   3.515186771869138*^9}, 3.515186802889181*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", "\n", 
      "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"b", "*", "A"}], "-", 
                 RowBox[{"a", "*", "B"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, {
   3.513655995829051*^9, 3.513656050769128*^9}, {3.513656083469174*^9, 
   3.5136560932891874`*^9}, {3.513656132629243*^9, 3.5136561410092545`*^9}, {
   3.513656206919347*^9, 3.5136562092793503`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]],
 " "
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.5011791668716116`*^9, 
   3.5011791710116177`*^9}, {3.501353551475207*^9, 3.5013535531444097`*^9}, 
   3.5016214475306363`*^9, 3.501621732503936*^9, 3.50163764784552*^9, {
   3.513654551447029*^9, 3.51365455217703*^9}, {3.5136566220499277`*^9, 
   3.5136566439099584`*^9}, {3.5138852062644854`*^9, 3.5138852090344896`*^9}}],

Cell[TextData[{
 "Rule 14: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5136558067487864`*^9, 3.5136558085287886`*^9}, {
   3.5136565322798023`*^9, 3.5136565328398027`*^9}, {3.5165824220419507`*^9, 
   3.5165824224619513`*^9}, {3.5165926931722584`*^9, 3.516592693862259*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "B", " ", 
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Csc", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", "n"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "A", " ", "n"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "B", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "n"}], "-", "1"}], ")"}]}], "+", 
          RowBox[{"b", " ", "A", " ", "n"}]}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.513278609965268*^9, 3.513278645275317*^9}, {3.513278681485368*^9, 
   3.513278702895398*^9}, 3.513278843665595*^9, {3.513656669489994*^9, 
   3.5136567604401217`*^9}, {3.5136568072701874`*^9, 3.513656829250218*^9}, {
   3.514843382516696*^9, 3.514843386354303*^9}, {3.515186778569147*^9, 
   3.5151867879591603`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "B", "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "n"}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", "n"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", "*", "n"}], "-", "1"}], ")"}]}], "+", 
               RowBox[{"b", "*", "A", "*", "n"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, {3.513656934580365*^9, 3.513656989690442*^9}, {
   3.513657056540536*^9, 3.5136570847905755`*^9}, {3.5136572776408453`*^9, 
   3.513657278700847*^9}, 3.513795095427431*^9, {3.5148433901763096`*^9, 
   3.5148433928127146`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        SuperscriptBox["a", "2"]}], "=", 
       SuperscriptBox["b", "2"]}]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.5134440458483133`*^9, 
   3.5134440464283147`*^9}, 3.5147370720234575`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["c",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.508727955943869*^9, {
   3.5087281208361588`*^9, 3.5087281279809713`*^9}, {3.5087811392187877`*^9, 
   3.5087811399587884`*^9}, {3.5087812182888985`*^9, 
   3.5087812191188993`*^9}, {3.50989505179342*^9, 3.5098950847434664`*^9}, {
   3.510585688098961*^9, 3.510585693578969*^9}, {3.511370195524361*^9, 
   3.511370201052677*^9}, {3.512153982992205*^9, 3.5121539832322054`*^9}, 
   3.513293185958044*^9, 3.514737778391819*^9, 3.514848215051588*^9, {
   3.515186860469262*^9, 3.5151868633992662`*^9}, 3.516583712173757*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.500666948156269*^9, 3.5006669508262725`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox["z", "k"]}]}], 
    RowBox[{
     SuperscriptBox["z", 
      FractionBox[
       RowBox[{"k", "+", "1"}], "2"]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["z", "k"]}]}]]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"A", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["z", "k"]}]}]]}], 
     RowBox[{"a", " ", 
      SuperscriptBox["z", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]]}]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], ")"}], 
      SuperscriptBox["z", 
       FractionBox[
        RowBox[{"k", "-", "1"}], "2"]]}], 
     RowBox[{"a", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["z", "k"]}]}]]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979901569434958`*^9, 
   3.4979901589402995`*^9}, {3.498674630504018*^9, 3.49867468184409*^9}, {
   3.512259136155183*^9, 3.5122591665128365`*^9}, {3.515106250486184*^9, 
   3.515106256956193*^9}, {3.515106293176244*^9, 3.515106296946249*^9}, {
   3.515107178127483*^9, 3.5151072484475813`*^9}, {3.5165835318435044`*^9, 
   3.516583655773678*^9}}],

Cell[TextData[{
 "Rule c: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, 3.500401902143732*^9, {
   3.5004019322673855`*^9, 3.5004019348725896`*^9}, {3.500431975630224*^9, 
   3.500431976700285*^9}, {3.500596487572508*^9, 3.5005964955909224`*^9}, {
   3.5005976481165457`*^9, 3.50059769596183*^9}, {3.50059778134078*^9, 
   3.5005977822611814`*^9}, 3.500603436159915*^9, 3.500752664340207*^9, {
   3.501806195427613*^9, 3.501806195427613*^9}, {3.502247096986684*^9, 
   3.50224710549417*^9}, {3.504814565459381*^9, 3.504814566309382*^9}, 
   3.5087900706784873`*^9, 3.5147377802618217`*^9, 3.5148482172511916`*^9, {
   3.5165833953033133`*^9, 3.5165833953033133`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["A", "a"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       FractionBox[
        RowBox[{"k", "-", "1"}], "2"]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, {
   3.5004019027833333`*^9, 3.5004019090077443`*^9}, {3.5004019461670094`*^9, 
   3.5004019604098344`*^9}, {3.5004020022023077`*^9, 
   3.5004020999052796`*^9}, {3.500403170537961*^9, 3.5004031709747615`*^9}, {
   3.5004032188980455`*^9, 3.500403243093688*^9}, {3.500596131704683*^9, 
   3.5005961322818837`*^9}, {3.500596573684659*^9, 3.50059658569668*^9}, {
   3.500596750360569*^9, 3.500596757676982*^9}, {3.5005968433423324`*^9, 
   3.500596857273157*^9}, {3.5005972743710895`*^9, 3.5005972953687263`*^9}, {
   3.5005986514683084`*^9, 3.5005986952419853`*^9}, {3.500598795206961*^9, 
   3.5005987969385643`*^9}, {3.5005989433292212`*^9, 
   3.5005989622364545`*^9}, {3.500691131426506*^9, 3.5006911595265455`*^9}, {
   3.500698437682624*^9, 3.5006985085691485`*^9}, {3.5006991256250324`*^9, 
   3.5006991261554337`*^9}, {3.500699909510809*^9, 3.5006999123968143`*^9}, {
   3.5007476294511504`*^9, 3.500747637191161*^9}, {3.500747709211262*^9, 
   3.500747734041297*^9}, {3.500749692956047*^9, 3.500749800106197*^9}, 
   3.5007506441073785`*^9, {3.5007507213474865`*^9, 3.500750734577505*^9}, {
   3.5007516906588435`*^9, 3.5007517043488626`*^9}, {3.5007517576689377`*^9, 
   3.5007517834289737`*^9}, 3.5007528682704926`*^9, 3.5007529926106663`*^9, {
   3.500753121560847*^9, 3.50075314536088*^9}, 3.5007532221909876`*^9, 
   3.5007535481214437`*^9, 3.500753878361906*^9, 3.500753918851963*^9, {
   3.5007554555241146`*^9, 3.5007554654541283`*^9}, {3.5007555235842094`*^9, 
   3.5007555294842176`*^9}, {3.5022471389500837`*^9, 
   3.5022471410552044`*^9}, {3.5048144990692873`*^9, 3.504814501419291*^9}, {
   3.5087884836062655`*^9, 3.5087885150763097`*^9}, {3.5132931484579916`*^9, 
   3.5132931504579945`*^9}, {3.515186865479269*^9, 3.5151868723492785`*^9}, 
   3.5165830422428193`*^9, {3.5165832014230423`*^9, 3.516583262373127*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"A", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "A"}], "-", 
         RowBox[{"b", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.500401911082548*^9, 3.500401988302684*^9}, {3.50040213985695*^9, 
   3.5004021729914083`*^9}, {3.5004031800539775`*^9, 3.500403180319178*^9}, {
   3.500403232142469*^9, 3.500403268053732*^9}, {3.5004319798384647`*^9, 
   3.5004319809015255`*^9}, {3.5005965174777603`*^9, 3.500596550487418*^9}, {
   3.5005972239830008`*^9, 3.500597224747402*^9}, 3.500597471227835*^9, {
   3.5005975330039434`*^9, 3.5005975372471514`*^9}, {3.5005976992690353`*^9, 
   3.500597700205037*^9}, {3.500597773057165*^9, 3.5005977749135685`*^9}, 
   3.5005981390074086`*^9, 3.500598274290846*^9, {3.5005987787177324`*^9, 
   3.5005988410086412`*^9}, {3.5005988915527306`*^9, 3.500598897730341*^9}, {
   3.5006911912365904`*^9, 3.5006912140666223`*^9}, {3.500698375032914*^9, 
   3.5006983872945356`*^9}, {3.5006985524520254`*^9, 3.500698556804433*^9}, {
   3.500698594132099*^9, 3.5006986357997723`*^9}, {3.5006991295250397`*^9, 
   3.500699130492241*^9}, {3.5006999309920473`*^9, 3.5006999574028935`*^9}, {
   3.5007476502811794`*^9, 3.5007476639111986`*^9}, {3.5007477113312654`*^9, 
   3.5007477359912996`*^9}, {3.5007481338098617`*^9, 3.500748134229862*^9}, {
   3.5007484134002533`*^9, 3.5007484296702757`*^9}, {3.5007489493750057`*^9, 
   3.5007489584850187`*^9}, {3.500749461305722*^9, 3.500749464515727*^9}, 
   3.5007498178562217`*^9, {3.5007500405865335`*^9, 3.500750069596574*^9}, {
   3.500750792317586*^9, 3.5007507956375904`*^9}, {3.500750867397691*^9, 
   3.5007509035977416`*^9}, {3.500751863109085*^9, 3.5007518872391186`*^9}, {
   3.500751977369245*^9, 3.5007519775292454`*^9}, {3.500752728550297*^9, 
   3.500752731740301*^9}, {3.500754065232168*^9, 3.500754107942228*^9}, {
   3.500755473384139*^9, 3.5007555134441957`*^9}, {3.5018061225754848`*^9, 
   3.5018061322475023`*^9}, {3.501806181122388*^9, 3.5018061832907915`*^9}, {
   3.5022475679486213`*^9, 3.5022475700347404`*^9}, {3.5087885328163347`*^9, 
   3.5087885565263677`*^9}, {3.5132931522579975`*^9, 3.513293155688002*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"A", "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}]}]}]}], "]"}], ",", "x"}], "]"}]}], " ", 
    "-", " ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}]}], ")"}], "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x"}], "]"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, {3.497990132482653*^9, 3.4979901406570673`*^9}, 
   3.4986745773039436`*^9, {3.4986787675998096`*^9, 3.498678777519824*^9}, {
   3.4986788309798985`*^9, 3.498678845569919*^9}, {3.49867924992649*^9, 
   3.498679252046493*^9}, {3.5031153583578453`*^9, 3.503115386016694*^9}, {
   3.503119924089466*^9, 3.5031199310938787`*^9}, {3.5053446902838526`*^9, 
   3.505344690293853*^9}, {3.509895255133705*^9, 3.509895256113706*^9}, 
   3.5098975030420127`*^9, 3.5104337999942102`*^9, {3.5104561655940933`*^9, 
   3.5104561873341236`*^9}, {3.5105097169822454`*^9, 3.5105097323950725`*^9}, 
   3.510514470528195*^9, 3.511807262392017*^9, 3.511807696142624*^9, 
   3.512259217696526*^9, {3.5122593521443624`*^9, 3.5122593628303814`*^9}, 
   3.5122595201878576`*^9, {3.5122597100089912`*^9, 3.512259715983802*^9}, 
   3.513047172354807*^9, 3.5130476907209682`*^9, 3.514614037618992*^9, {
   3.5148470111902723`*^9, 3.5148470157298803`*^9}, {3.5148478735141873`*^9, 
   3.514847876602993*^9}, {3.514847937714301*^9, 3.5148479413335075`*^9}, {
   3.515102721701244*^9, 3.515102746131278*^9}, {3.5151039322129383`*^9, 
   3.51510393330294*^9}, {3.5151040234830666`*^9, 3.515104037623086*^9}, {
   3.5151041744732776`*^9, 3.515104212833331*^9}, {3.515104474223697*^9, 
   3.515104481343707*^9}, {3.515106541636592*^9, 3.5151065949566665`*^9}, {
   3.515107103187378*^9, 3.5151071565574527`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["d",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.508727955943869*^9, {
   3.5087281208361588`*^9, 3.5087281279809713`*^9}, {3.5087811392187877`*^9, 
   3.5087811399587884`*^9}, {3.5087812182888985`*^9, 
   3.5087812191188993`*^9}, {3.50989505179342*^9, 3.5098950847434664`*^9}, {
   3.510585688098961*^9, 3.510585693578969*^9}, {3.511370195524361*^9, 
   3.511370201052677*^9}, {3.512153982992205*^9, 3.5121539832322054`*^9}, 
   3.513293185958044*^9, 3.513293220058092*^9, 3.5138972867862654`*^9, {
   3.513897592078802*^9, 3.5138976112668357`*^9}, {3.513963351520548*^9, 
   3.513963408055047*^9}, 3.5147377828018255`*^9, 3.514848220121597*^9, {
   3.515186881109291*^9, 3.5151868840592947`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5021341806778545`*^9, 3.5021341861222644`*^9}, {3.5021585244593067`*^9, 
   3.502158527439311*^9}}],

Cell[TextData[{
 "Rule d: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5012672318508615`*^9, 3.5012672409508743`*^9}, {
   3.5018067804754405`*^9, 3.5018068133914986`*^9}, {3.501807130150055*^9, 
   3.5018071318504577`*^9}, {3.501881120717829*^9, 3.501881120717829*^9}, {
   3.5021348082093573`*^9, 3.502134808926959*^9}, {3.502158538829327*^9, 
   3.502158539729328*^9}, {3.5044890156241617`*^9, 3.504489016144162*^9}, 
   3.5087900735984917`*^9, 3.513897683806963*^9, 3.5139634949783993`*^9, 
   3.514737785081828*^9, 3.514848222602001*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["B", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501265980199109*^9, 3.501266014289157*^9}, {3.501266063349225*^9, 
   3.501266065199228*^9}, {3.501806833780734*^9, 3.5018069301109033`*^9}, {
   3.5021342020030923`*^9, 3.5021342253563333`*^9}, {3.502134496879611*^9, 
   3.502134506224027*^9}, {3.5021346420222654`*^9, 3.502134643972269*^9}, {
   3.50213470708998*^9, 3.502134710818386*^9}, 3.5021348366950073`*^9, 
   3.5021584539192085`*^9, {3.502158484239251*^9, 3.5021585181092978`*^9}, {
   3.5021586054694204`*^9, 3.502158628639453*^9}, {3.50215866920951*^9, 
   3.5021587203395815`*^9}, {3.5021587517196255`*^9, 3.502158754329629*^9}, 
   3.508788591066416*^9, {3.513293230678107*^9, 3.51329323302811*^9}, {
   3.5151868861192975`*^9, 3.5151868946893096`*^9}, 3.515976046639243*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.502134774372898*^9, 3.5021347791621065`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"B", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, {3.5021347842009153`*^9, 
   3.5021347975545387`*^9}, {3.5021349097187357`*^9, 3.502134918345551*^9}, {
   3.5021585434093337`*^9, 3.502158577399381*^9}, 3.502158899619832*^9, {
   3.513293233508111*^9, 3.5132932363981147`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
    RowBox[{"m", "/", "2"}]], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, 3.5107929120112553`*^9, {
   3.510864363862485*^9, 3.5108643733624983`*^9}, 3.513605913762121*^9, {
   3.513880618588063*^9, 3.513880629398078*^9}, {3.5138855073249073`*^9, 
   3.513885522434928*^9}, {3.5138981448657727`*^9, 3.5138981686714144`*^9}, 
   3.5138992352668886`*^9, {3.513964296538372*^9, 3.513964297118373*^9}, {
   3.5139981099436064`*^9, 3.5139981123148108`*^9}, {3.5151869112593327`*^9, 
   3.5151869131393356`*^9}, 3.5151869717794175`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 4 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox["1", "2"]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501897999882035*^9, 3.5018980004280357`*^9}, 3.508786823273941*^9, {
   3.5133877723772554`*^9, 3.5133877743972583`*^9}, {3.5133974922150817`*^9, 
   3.513397493415084*^9}, {3.5138806860881577`*^9, 3.513880744178239*^9}, 
   3.5138858761754236`*^9, {3.5138859110554724`*^9, 3.513885911375473*^9}, {
   3.513898178249831*^9, 3.513898219465104*^9}, 3.5138990643061886`*^9, {
   3.513917468495978*^9, 3.5139174842460003`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"j", " ", "m"}]}], "=", 
     FractionBox["1", "2"]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, 3.5138883567908974`*^9, {
   3.5139145994019613`*^9, 3.5139146066819715`*^9}, 3.5139176939662933`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", "a", " ", "A", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        RowBox[{"d", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}]}], "+", 
  RowBox[{"B", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.5138986566618724`*^9, 3.513898742430823*^9}, {
   3.5138987872965016`*^9, 3.5138989057007093`*^9}, {3.5138990098308926`*^9, 
   3.513899010517294*^9}, 3.513917214385622*^9, {3.5139173381257954`*^9, 
   3.5139173623558292`*^9}, {3.5139175623461094`*^9, 
   3.5139175631561103`*^9}, {3.5151869176793423`*^9, 3.515186924419351*^9}, {
   3.5151869741494207`*^9, 3.515186977339425*^9}, 3.5159760680268807`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "a", "*", "A", "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"B", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], "]"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          "m"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "m"}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, {3.5018980188984685`*^9, 3.50189801985007*^9}, {
   3.5018993588676224`*^9, 3.5018993591016226`*^9}, {3.501899407617708*^9, 
   3.5018994162601233`*^9}, {3.5019584349071083`*^9, 3.501958435137108*^9}, 
   3.502043281447963*^9, {3.502043836886939*^9, 3.5020438378697405`*^9}, {
   3.5020440523233175`*^9, 3.502044053150119*^9}, {3.5020452897486906`*^9, 
   3.5020452909654927`*^9}, {3.5023272013119135`*^9, 3.5023272098607283`*^9}, 
   3.5023293759713326`*^9, {3.502330255532078*^9, 3.502330260882887*^9}, {
   3.505169008467469*^9, 3.5051690099755554`*^9}, {3.505355146667435*^9, 
   3.5053551630074577`*^9}, 3.5053551980475073`*^9, 3.505363517073367*^9, 
   3.5133879210874643`*^9, {3.5133880027075777`*^9, 3.513388003137579*^9}, 
   3.5133880665876675`*^9, 3.5133881203977427`*^9, 3.5133958374610467`*^9, 
   3.5134409700670853`*^9, {3.513714974962614*^9, 3.5137149768034177`*^9}, {
   3.5138812261089134`*^9, 3.5138812634489655`*^9}, {3.5138813489190855`*^9, 
   3.5138813692991138`*^9}, {3.513881427699196*^9, 3.513881435869207*^9}, {
   3.5138866797465487`*^9, 3.513886735226626*^9}, 3.5138867931867075`*^9, {
   3.5138992950149937`*^9, 3.513899325372647*^9}, {3.513899359333906*^9, 
   3.5138993656363173`*^9}, 3.5139175074160323`*^9, 3.5139175497160916`*^9, {
   3.5139175899361477`*^9, 3.513917607206172*^9}, {3.5139176628362503`*^9, 
   3.513917673426265*^9}, 3.5139187270377398`*^9, 3.516820993866935*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.513916690654889*^9, 3.5139166933448925`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}]]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"B", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}], "b"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}]]}]}]],
  CellChangeTimes->{{3.513916733274948*^9, 3.5139167911750298`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354923854859*^9, 
   3.508354923854859*^9}, {3.508361590872611*^9, 3.5083615983626213`*^9}, {
   3.508361640892681*^9, 3.508361643482684*^9}, 3.5108633469910617`*^9, {
   3.5108842882102137`*^9, 3.510884343449911*^9}, {3.5108843749619665`*^9, 
   3.510884406786022*^9}, {3.513916725294937*^9, 3.5139167267249393`*^9}, {
   3.51391679832504*^9, 3.5139168017350445`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"j", " ", "m"}]}], "=", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, 3.5138883567908974`*^9, {
   3.5139145994019613`*^9, 3.5139146066819715`*^9}, {3.513917889356567*^9, 
   3.513917900756583*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["B", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " ", 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], " ", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5108845596722918`*^9, 3.510884601277564*^9}, {3.5139134911004095`*^9, 
   3.513913502070425*^9}, {3.513913704260708*^9, 3.513913873020944*^9}, {
   3.513913907730993*^9, 3.5139139106109967`*^9}, {3.513914028481162*^9, 
   3.513914030981165*^9}, {3.513914229171443*^9, 3.513914238101455*^9}, 
   3.513914542761882*^9, {3.513916297654339*^9, 3.513916328704382*^9}, {
   3.5139163677544365`*^9, 3.513916400614483*^9}, {3.513916463754571*^9, 
   3.5139164797445936`*^9}, 3.51391659143475*^9, 3.513916631264806*^9, 
   3.5139169852053013`*^9, {3.5151869296393585`*^9, 3.515186937249369*^9}, {
   3.51518698058943*^9, 3.515186984239435*^9}, 3.515976072488488*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"B", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "m"}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, {3.5138883597509017`*^9, 
   3.5138884250309935`*^9}, {3.5138888699116163`*^9, 3.513888889801644*^9}, {
   3.5138924945366907`*^9, 3.51389252984674*^9}, {3.513892659376921*^9, 
   3.5138926608669233`*^9}, {3.5139003700812826`*^9, 
   3.5139003856657095`*^9}, {3.5139131128118644`*^9, 3.513913114911867*^9}, {
   3.5139132757920923`*^9, 3.513913283242103*^9}, {3.5139140972712584`*^9, 
   3.513914206441411*^9}, {3.5139143038815475`*^9, 3.5139143075315523`*^9}, {
   3.513914633592009*^9, 3.5139146431720223`*^9}, {3.5139147818822165`*^9, 
   3.513914785032221*^9}, {3.5139158452037053`*^9, 3.5139158581137233`*^9}, 
   3.513916930955225*^9, 3.5139176260461984`*^9, {3.5139178653665333`*^9, 
   3.513917880516555*^9}, 3.5139221051104927`*^9, {3.51597610754175*^9, 
   3.5159761082749515`*^9}, 3.5168209939069347`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 5 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox["1", "2"]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501897999882035*^9, 3.5018980004280357`*^9}, 3.508786823273941*^9, {
   3.5133877723772554`*^9, 3.5133877743972583`*^9}, {3.5133974922150817`*^9, 
   3.513397493415084*^9}, {3.5138806860881577`*^9, 3.513880744178239*^9}, 
   3.5138858761754236`*^9, {3.5138859110554724`*^9, 3.513885911375473*^9}, {
   3.513898178249831*^9, 3.513898219465104*^9}, 3.5138990643061886`*^9, 
   3.5139011152205925`*^9, {3.513901203953548*^9, 3.5139012043747487`*^9}, {
   3.513901406691504*^9, 3.513901407331105*^9}, {3.513901732482476*^9, 
   3.513901733059677*^9}, {3.513963452920726*^9, 3.513963464137145*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"j", " ", "m"}]}], "=", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, 3.5138883567908974`*^9, {
   3.5139145994019613`*^9, 3.5139146066819715`*^9}, {3.513917889356567*^9, 
   3.513917900756583*^9}, 3.513963552511301*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", "A", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        RowBox[{"d", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "a"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.5138986566618724`*^9, 3.513898742430823*^9}, {
   3.5138987872965016`*^9, 3.5138989057007093`*^9}, {3.5138990098308926`*^9, 
   3.513899010517294*^9}, 3.513900489218692*^9, {3.5139005315727663`*^9, 
   3.5139005342715707`*^9}, {3.5139005658460264`*^9, 
   3.5139005835832577`*^9}, {3.513900618480519*^9, 3.5139006682914057`*^9}, {
   3.5139007356367245`*^9, 3.5139007646215754`*^9}, 3.513900827567686*^9, 
   3.513963481109975*^9, {3.5139635201100435`*^9, 3.513963524166051*^9}, {
   3.5139636111206036`*^9, 3.513963611869405*^9}, {3.5151869417493753`*^9, 
   3.515186949219386*^9}, {3.5151869872294393`*^9, 3.5151869905294437`*^9}, 
   3.515976147585021*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "A", "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
            "m"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", 
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ")"}]}], ",", "x"}],
        "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "m"}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, {3.5018980188984685`*^9, 3.50189801985007*^9}, {
   3.5018993588676224`*^9, 3.5018993591016226`*^9}, {3.501899407617708*^9, 
   3.5018994162601233`*^9}, {3.5019584349071083`*^9, 3.501958435137108*^9}, 
   3.502043281447963*^9, {3.502043836886939*^9, 3.5020438378697405`*^9}, {
   3.5020440523233175`*^9, 3.502044053150119*^9}, {3.5020452897486906`*^9, 
   3.5020452909654927`*^9}, {3.5023272013119135`*^9, 3.5023272098607283`*^9}, 
   3.5023293759713326`*^9, {3.502330255532078*^9, 3.502330260882887*^9}, {
   3.505169008467469*^9, 3.5051690099755554`*^9}, {3.505355146667435*^9, 
   3.5053551630074577`*^9}, 3.5053551980475073`*^9, 3.505363517073367*^9, 
   3.5133879210874643`*^9, {3.5133880027075777`*^9, 3.513388003137579*^9}, 
   3.5133880665876675`*^9, 3.5133881203977427`*^9, 3.5133958374610467`*^9, 
   3.5134409700670853`*^9, {3.513714974962614*^9, 3.5137149768034177`*^9}, {
   3.5138812261089134`*^9, 3.5138812634489655`*^9}, {3.5138813489190855`*^9, 
   3.5138813692991138`*^9}, {3.513881427699196*^9, 3.513881435869207*^9}, {
   3.5138866797465487`*^9, 3.513886735226626*^9}, 3.5138867931867075`*^9, {
   3.5138992950149937`*^9, 3.513899325372647*^9}, {3.513899359333906*^9, 
   3.5138993656363173`*^9}, {3.513901750562908*^9, 3.5139018147258205`*^9}, 
   3.5139045467634215`*^9, {3.513963731777581*^9, 3.5139637553676147`*^9}, {
   3.5139638229277086`*^9, 3.5139638427077365`*^9}, {3.51597615263943*^9, 
   3.5159761534974318`*^9}, 3.5168209939369345`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "9"}], "-", "10"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5023422929020205`*^9, 3.502342295008024*^9}, 
   3.502570511534437*^9, {3.5044892028544235`*^9, 3.5044892144644403`*^9}, {
   3.504489358774642*^9, 3.504489360914645*^9}, {3.5046347449107575`*^9, 
   3.504634747370761*^9}, 3.513299763190216*^9, {3.5132998063802767`*^9, 
   3.5132998065502768`*^9}, {3.515187235359787*^9, 3.515187238519791*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 4 with ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "B", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
    RowBox[{"b", " ", "A", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "2"}], "2"]}], ")"}]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5021341806778545`*^9, 3.5021341861222644`*^9}, {3.502321037554247*^9, 
   3.502321053138674*^9}, {3.513294202969468*^9, 3.51329420422947*^9}, {
   3.513299398189705*^9, 3.513299421219737*^9}, {3.513885227724516*^9, 
   3.5138852325245223`*^9}}],

Cell[TextData[{
 "Derivation: Rule 3 with ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "B", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
    RowBox[{"b", " ", "A", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "2"}], "2"]}], ")"}]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5021341806778545`*^9, 3.5021341861222644`*^9}, {3.502321037554247*^9, 
   3.502321053138674*^9}, {3.502571926066417*^9, 3.502571927466419*^9}, {
   3.5132942159294863`*^9, 3.513294216169486*^9}, {3.5132994047497144`*^9, 
   3.5132994235297403`*^9}, {3.5138852351345263`*^9, 3.513885237374529*^9}}],

Cell[TextData[{
 "Rule 9a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"b", " ", "A"}], "-", 
         RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"j", " ", "k", " ", "m"}], "+", 
         FractionBox[
          RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", 
       "\[And]", " ", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{"b", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "2"}], "2"]}], ")"}]}]}]}], "=", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5012672318508615`*^9, 3.5012672409508743`*^9}, {
   3.5018067804754405`*^9, 3.5018068133914986`*^9}, {3.501807130150055*^9, 
   3.5018071318504577`*^9}, {3.501881120717829*^9, 3.501881120717829*^9}, {
   3.5021348082093573`*^9, 3.502134808926959*^9}, {3.5023211358812194`*^9, 
   3.5023211571752567`*^9}, {3.502568605383803*^9, 3.5025686087534084`*^9}, {
   3.5044890855842595`*^9, 3.5044890863642607`*^9}, {3.5044892178644447`*^9, 
   3.504489218294445*^9}, {3.504489346634625*^9, 3.5044893470046253`*^9}, {
   3.5046347943608265`*^9, 3.504634795360828*^9}, 3.513299438079761*^9, {
   3.513299525149883*^9, 3.513299539729903*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"a", " ", "A", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "+", 
         RowBox[{"j", " ", "k"}]}]]}], 
      RowBox[{"d", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", " ", "k", " ", "m"}], "+", 
         FractionBox[
          RowBox[{"k", "+", "1"}], "2"]}], ")"}], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           "k"]}]}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501265980199109*^9, 3.501266014289157*^9}, {3.501266063349225*^9, 
   3.501266065199228*^9}, {3.501806833780734*^9, 3.5018069301109033`*^9}, {
   3.5021342020030923`*^9, 3.5021342253563333`*^9}, {3.502134496879611*^9, 
   3.502134506224027*^9}, {3.5021346420222654`*^9, 3.502134643972269*^9}, {
   3.50213470708998*^9, 3.502134710818386*^9}, 3.5021348366950073`*^9, {
   3.5023210574754815`*^9, 3.502321060673487*^9}, {3.513299478779818*^9, 
   3.513299498899846*^9}, {3.5151872494298067`*^9, 3.5151872504298077`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.502134774372898*^9, 3.5021347791621065`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"a", "*", "A", "*", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], 
      ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "2"}], ")"}], "/", "2"}]}], ")"}]}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, {3.5021347842009153`*^9, 
   3.5021347975545387`*^9}, {3.5021349097187357`*^9, 3.502134918345551*^9}, {
   3.5023210678651*^9, 3.5023211154295835`*^9}, {3.502321202368536*^9, 
   3.5023212195753665`*^9}, 3.502420395924906*^9, {3.5051560992667017`*^9, 
   3.5051561013067045`*^9}, 3.5132995691099443`*^9, 3.513299615340009*^9, {
   3.5132996485900555`*^9, 3.5132997239701614`*^9}, 3.516820845466727*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 4 with ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5021341806778545`*^9, 3.5021341861222644`*^9}, {3.5132942325395093`*^9, 
   3.5132942331495104`*^9}, {3.513298635048637*^9, 3.51329863745864*^9}, {
   3.513885242734537*^9, 3.513885246594542*^9}}],

Cell[TextData[{
 "Rule 9b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{"b", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "2"}], "2"]}], ")"}]}]}], "\[NotEqual]", 
       "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5012672318508615`*^9, 3.5012672409508743`*^9}, {
   3.5018067804754405`*^9, 3.5018068133914986`*^9}, {3.501807130150055*^9, 
   3.5018071318504577`*^9}, {3.501881120717829*^9, 3.501881120717829*^9}, {
   3.5021348082093573`*^9, 3.502134808926959*^9}, {3.502569204618056*^9, 
   3.502569208908063*^9}, {3.5044891413943377`*^9, 3.5044891422243385`*^9}, 
   3.5044891829743958`*^9, {3.5044892233744526`*^9, 3.504489223854453*^9}, {
   3.5044893503246303`*^9, 3.5044893508146305`*^9}, {3.504634797650831*^9, 
   3.5046347992508335`*^9}, 3.513298412398325*^9, {3.5132986013385897`*^9, 
   3.513298620618616*^9}, {3.513811452342993*^9, 3.5138114542411013`*^9}, {
   3.51381150824419*^9, 3.5138115188627977`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"a", " ", "A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "B", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
     RowBox[{"b", " ", "A", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", 
        FractionBox[
         RowBox[{"k", "+", "2"}], "2"]}], ")"}]}]}], 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.5132957913262205`*^9, 3.5132958414262905`*^9}, {
   3.5132958739863367`*^9, 3.513295942186432*^9}, {3.5132960059465213`*^9, 
   3.513296009916527*^9}, {3.513296907416218*^9, 3.513296913886227*^9}, {
   3.513297056686427*^9, 3.513297111886504*^9}, {3.513297181746602*^9, 
   3.5132972149666486`*^9}, {3.513297249386697*^9, 3.513297275586734*^9}, {
   3.513297342336827*^9, 3.513297355286845*^9}, {3.513297404496914*^9, 
   3.513297466557001*^9}, 3.5132975913071756`*^9, 3.5132979538676834`*^9, {
   3.5151872537598124`*^9, 3.515187257249817*^9}, {3.515976288734069*^9, 
   3.515976293991278*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.502134774372898*^9, 3.5021347791621065`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", "A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], 
       ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "B", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"j", "*", "k", "*", "m"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
         RowBox[{"b", "*", "A", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"j", "*", "k", "*", "m"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "+", "2"}], ")"}], "/", "2"}]}], ")"}]}]}], ")"}], 
       "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "2"}], ")"}], "/", "2"}]}], ")"}]}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, {3.5021347842009153`*^9, 
   3.5021347975545387`*^9}, {3.5021349097187357`*^9, 3.502134918345551*^9}, {
   3.502321120811593*^9, 3.5023211250080004`*^9}, {3.505156103286708*^9, 
   3.505156103796708*^9}, 3.5132982245480623`*^9, {3.513298267568122*^9, 
   3.513298304338174*^9}, {3.513298432208353*^9, 3.513298454818384*^9}, {
   3.5132985126684656`*^9, 3.5132985139484673`*^9}, 3.5132985747085524`*^9, {
   3.5138114579783154`*^9, 3.5138114833997693`*^9}, 3.513811602841601*^9, {
   3.5159762629316235`*^9, 3.515976263696025*^9}, 3.5168208455067267`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3 with ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, {3.501808958164465*^9, 
   3.5018089598336678`*^9}, {3.5021319515383387`*^9, 3.502131961600356*^9}, {
   3.513294240689521*^9, 3.513294240929521*^9}, {3.513299366519661*^9, 
   3.513299367569662*^9}, {3.513885249394546*^9, 3.5138852526945505`*^9}}],

Cell[TextData[{
 "Rule 10: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", 
        FractionBox[
         RowBox[{"k", "+", "2"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{"b", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "2"}], "2"]}], ")"}]}]}], "\[NotEqual]", 
       "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.501812061374316*^9, 3.501812073838738*^9}, {
   3.5019719909841585`*^9, 3.501971995094164*^9}, {3.501972122124342*^9, 
   3.501972125344346*^9}, {3.501982915863229*^9, 3.501982938943261*^9}, {
   3.502133139048425*^9, 3.502133139048425*^9}, {3.5021337393998795`*^9, 
   3.502133747792694*^9}, {3.502135001977298*^9, 3.502135004254902*^9}, {
   3.502570209384014*^9, 3.5025702188040276`*^9}, {3.504489090224266*^9, 
   3.5044890912242675`*^9}, 3.504489186854401*^9, {3.504489227104458*^9, 
   3.5044892275544586`*^9}, 3.5044893547346363`*^9, {3.50463480380084*^9, 
   3.504634804360841*^9}, {3.513299329559609*^9, 3.5132993535496426`*^9}, {
   3.5136425246283073`*^9, 3.513642542208332*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "2"}], "2"]}], ")"}], 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "B", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
     RowBox[{"b", " ", "A", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", 
        FractionBox[
         RowBox[{"k", "+", "2"}], "2"]}], ")"}]}]}], 
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "2"}], "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.5132957913262205`*^9, 3.5132958414262905`*^9}, {
   3.5132958739863367`*^9, 3.513295942186432*^9}, {3.5132960059465213`*^9, 
   3.513296009916527*^9}, {3.513296907416218*^9, 3.513296913886227*^9}, {
   3.513297056686427*^9, 3.513297111886504*^9}, {3.513297181746602*^9, 
   3.5132972149666486`*^9}, {3.513297249386697*^9, 3.513297275586734*^9}, {
   3.513297342336827*^9, 3.513297355286845*^9}, {3.513297404496914*^9, 
   3.513297466557001*^9}, 3.5132975913071756`*^9, 3.5132979538676834`*^9, {
   3.513298729658769*^9, 3.5132987369187794`*^9}, {3.513298768718824*^9, 
   3.5132988413889256`*^9}, {3.513299025909184*^9, 3.5132990396692033`*^9}, {
   3.5151872606098223`*^9, 3.5151872636598263`*^9}, {3.515976326376935*^9, 
   3.5159763289041395`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}, {
   3.50213305090347*^9, 3.5021330548034763`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "B", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "2"}], ")"}], "/", "2"}]}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], 
       ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "B", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"j", "*", "k", "*", "m"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
         RowBox[{"b", "*", "A", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"j", "*", "k", "*", "m"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "+", "2"}], ")"}], "/", "2"}]}], ")"}]}]}], ")"}], 
       "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "2"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "2"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "2"}], ")"}], "/", "2"}]}], ")"}]}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.5018091789952526`*^9, 3.5018091989008875`*^9}, {
   3.501819685414508*^9, 3.501819688050913*^9}, {3.501890085850887*^9, 
   3.5018900870308886`*^9}, {3.501971873003993*^9, 3.50197189934403*^9}, {
   3.5019724700148287`*^9, 3.5019724783748407`*^9}, {3.5019828227230988`*^9, 
   3.501982824323101*^9}, {3.501982949443276*^9, 3.501982954023282*^9}, 
   3.501983147063553*^9, {3.50213306269709*^9, 3.5021330721663074`*^9}, {
   3.5021331040107636`*^9, 3.5021331165375853`*^9}, {3.502133262351042*^9, 
   3.5021332870614853`*^9}, {3.5021336966558046`*^9, 3.502133710586629*^9}, {
   3.5021344151198673`*^9, 3.502134420377076*^9}, {3.5021349379703856`*^9, 
   3.5021349430403943`*^9}, 3.5023211845377045`*^9, {3.505156107256713*^9, 
   3.5051561077067137`*^9}, 3.5132991455193515`*^9, {3.51329920873944*^9, 
   3.5132992708595266`*^9}, {3.5136420293976145`*^9, 
   3.5136420439176345`*^9}, {3.5159763438333654`*^9, 3.515976344550967*^9}, 
   3.516820845536727*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "11"}], "-", "12"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "3"}], "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5023422929020205`*^9, 3.502342295008024*^9}, {
   3.5025708612849264`*^9, 3.502570865774933*^9}, {3.504489529334881*^9, 
   3.504489534184888*^9}, {3.504634749720764*^9, 3.504634751510767*^9}, 
   3.513309346154997*^9, {3.51330939917949*^9, 3.5133094295839434`*^9}, {
   3.513657185120716*^9, 3.5136571853007164`*^9}, {3.5151872934298677`*^9, 
   3.515187294389869*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 5 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
    FractionBox[
     RowBox[{"k", "+", "3"}], "2"]}], "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "B", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "+", 
    RowBox[{"b", " ", "A", " ", "n"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, 
   3.502342991533648*^9, {3.5024199587642937`*^9, 3.502419976454318*^9}, {
   3.5133071306083045`*^9, 3.5133071498899384`*^9}, {3.5133085132491336`*^9, 
   3.5133085132491336`*^9}, {3.5133088536153316`*^9, 3.513308854769734*^9}, {
   3.513885257484557*^9, 3.513885260754562*^9}}],

Cell[TextData[{
 "Rule 11a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"b", " ", "A"}], "-", 
         RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "3"}], "2"]}]}], "=", 
      RowBox[{
       RowBox[{"0", " ", "\[And]", " ", 
        RowBox[{
         RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
        RowBox[{
         RowBox[{"a", " ", "B", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "+", 
         RowBox[{"b", " ", "A", " ", "n"}]}]}], "=", "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5019715808135843`*^9, 
   3.5019715838335876`*^9}, {3.502139781132894*^9, 3.5021397864837036`*^9}, 
   3.5023430056048727`*^9, {3.5024190270329895`*^9, 3.502419043443012*^9}, {
   3.502420311074787*^9, 3.5024203142147913`*^9}, {3.50242035653485*^9, 
   3.502420363834861*^9}, {3.5024208417155294`*^9, 3.5024208454055347`*^9}, {
   3.5044894728548017`*^9, 3.5044894734748025`*^9}, {3.5046348150408554`*^9, 
   3.504634815530856*^9}, {3.5133072463605075`*^9, 3.5133072463605075`*^9}, {
   3.51330728164777*^9, 3.5133073135342255`*^9}, {3.5133081699705305`*^9, 
   3.5133081942753735`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.5023430354009247`*^9, 3.5023430695025845`*^9}, {3.5024199996643505`*^9, 
   3.5024200093543644`*^9}, 3.5048105907442083`*^9, {3.513307183476797*^9, 
   3.5133071939600153`*^9}, {3.513308099146406*^9, 3.5133081033272133`*^9}, 
   3.5133084924074965`*^9, {3.51518729494987*^9, 3.515187295639871*^9}, 
   3.5159763785154266`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}, {
   3.5023432395584836`*^9, 3.50234324313089*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "A"}], "*", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
      "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "+", 
      RowBox[{"b", "*", "A", "*", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501881231627984*^9, 3.5018812330179863`*^9}, 3.501971602063614*^9, {
   3.502139758169654*^9, 3.502139777420088*^9}, {3.502147729379987*^9, 
   3.502147737279998*^9}, {3.5021478179601107`*^9, 3.502147819850114*^9}, {
   3.5022124921152782`*^9, 3.502212493690881*^9}, {3.502311629208922*^9, 
   3.5023116620625796`*^9}, 3.502343018225295*^9, 3.502343248263299*^9, {
   3.5024185452523146`*^9, 3.5024185520123243`*^9}, 3.5024191386831455`*^9, {
   3.5024200236543846`*^9, 3.5024200566144304`*^9}, {3.502420280014743*^9, 
   3.502420301284773*^9}, 3.5024205849951706`*^9, {3.5051561630767913`*^9, 
   3.5051561639167924`*^9}, {3.513307210636445*^9, 3.5133072211040635`*^9}, {
   3.513307256453726*^9, 3.513307264066539*^9}, 3.5133073576823034`*^9, 
   3.5133073927615657`*^9, 3.5133074365664425`*^9, {3.5133085497063975`*^9, 
   3.513308576257644*^9}, {3.5133086764926205`*^9, 3.5133086894406433`*^9}, 
   3.516820845326727*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 5 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
    FractionBox[
     RowBox[{"k", "+", "3"}], "2"]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, 
   3.502342991533648*^9, {3.513306402040225*^9, 3.513306403491027*^9}, {
   3.513306551784888*^9, 3.5133065604273033`*^9}, {3.51330885803014*^9, 
   3.513308859200142*^9}, {3.5138852649445677`*^9, 3.51388526660457*^9}}],

Cell[TextData[{
 "Rule 11b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"b", " ", "A"}], "-", 
         RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "3"}], "2"]}]}], "=", 
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{"n", ">", 
        RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"a", " ", "B", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "+", 
         RowBox[{"b", " ", "A", " ", "n"}]}], "\[NotEqual]", "0"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5019715808135843`*^9, 
   3.5019715838335876`*^9}, {3.502139781132894*^9, 3.5021397864837036`*^9}, 
   3.5023430056048727`*^9, {3.5024190270329895`*^9, 3.502419043443012*^9}, {
   3.5025692416837206`*^9, 3.502569246207729*^9}, {3.5044894763448067`*^9, 
   3.5044894771548076`*^9}, {3.50463481824086*^9, 3.5046348186908607`*^9}, {
   3.5133067723224754`*^9, 3.5133067723224754`*^9}, {3.513306808608139*^9, 
   3.513306808608139*^9}, {3.513306907793113*^9, 3.5133069083703136`*^9}, {
   3.5133073094314184`*^9, 3.5133073094314184`*^9}, {3.5133087822764063`*^9, 
   3.513308787018815*^9}, {3.51528001250492*^9, 3.515280015312925*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"A", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "B", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "+", 
     RowBox[{"b", " ", "A", " ", "n"}]}], 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095542513719344`*^9, 3.509554323542035*^9}, {3.510172539341531*^9, 
   3.5101725420403357`*^9}, {3.510173494983609*^9, 3.5101735152636447`*^9}, {
   3.5132798504870043`*^9, 3.5132799133070927`*^9}, {3.5132800310872574`*^9, 
   3.5132800316472583`*^9}, {3.5132800984573517`*^9, 
   3.5132801027073574`*^9}, {3.513280379307745*^9, 3.513280408807786*^9}, {
   3.513306461554329*^9, 3.51330646191313*^9}, {3.5133065771973324`*^9, 
   3.5133065904261556`*^9}, {3.5133066528574653`*^9, 
   3.5133066600958776`*^9}, {3.513308612189308*^9, 3.5133086485217714`*^9}, {
   3.5151872994698763`*^9, 3.515187300969878*^9}, 3.515976393678653*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}, {
   3.5023432395584836`*^9, 3.50234324313089*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "A"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "B", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "+", 
         RowBox[{"b", "*", "A", "*", "n"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "+", 
      RowBox[{"b", "*", "A", "*", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501881231627984*^9, 3.5018812330179863`*^9}, 3.501971602063614*^9, {
   3.502139758169654*^9, 3.502139777420088*^9}, {3.502147729379987*^9, 
   3.502147737279998*^9}, {3.5021478179601107`*^9, 3.502147819850114*^9}, {
   3.5022124921152782`*^9, 3.502212493690881*^9}, {3.502311629208922*^9, 
   3.5023116620625796`*^9}, 3.502343018225295*^9, 3.502343248263299*^9, {
   3.5024185452523146`*^9, 3.5024185520123243`*^9}, 3.5024191386831455`*^9, {
   3.5024200387244053`*^9, 3.502420043994413*^9}, {3.5024206373352437`*^9, 
   3.5024206466452565`*^9}, {3.5051561773468113`*^9, 3.505156177966812*^9}, {
   3.5051562168468666`*^9, 3.5051562216368732`*^9}, {3.5133068375617895`*^9, 
   3.5133068722718506`*^9}, {3.5133069120831203`*^9, 3.513306959008003*^9}, {
   3.5133070281473246`*^9, 3.513307081249818*^9}, 3.5133074423384523`*^9, 
   3.513308708457077*^9, {3.5133087520903535`*^9, 3.51330875583436*^9}, 
   3.5133088295756893`*^9, {3.515279956126421*^9, 3.5152799605724287`*^9}, 
   3.5168208453567266`*^9, 3.516823734200899*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 6 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
    FractionBox[
     RowBox[{"k", "+", "3"}], "2"]}], "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "B", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "+", 
    RowBox[{"a", " ", "A", " ", "n"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, {3.5023426962407293`*^9, 
   3.502342703978343*^9}, {3.5024205066950607`*^9, 3.502420514805072*^9}, {
   3.506273925933417*^9, 3.506273925933417*^9}, {3.513307535969817*^9, 
   3.5133075367966185`*^9}, {3.5133092831464863`*^9, 3.513309292444103*^9}, {
   3.5138852702545753`*^9, 3.5138852738045797`*^9}}],

Cell[TextData[{
 "Rule 12a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"b", " ", "A"}], "-", 
         RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "3"}], "2"]}]}], "=", 
      RowBox[{
       RowBox[{"0", " ", "\[And]", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]",
         " ", 
        RowBox[{
         RowBox[{"b", " ", "B", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "+", 
         RowBox[{"a", " ", "A", " ", "n"}]}]}], "=", "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.501972517524895*^9, 3.5019725276349096`*^9}, {
   3.5019829062432156`*^9, 3.5019829076332173`*^9}, {3.5023429280727367`*^9, 
   3.502342934016347*^9}, {3.502419169213188*^9, 3.5024191822832065`*^9}, {
   3.5024207743254356`*^9, 3.5024207974354677`*^9}, {3.5024208692655687`*^9, 
   3.502420878975582*^9}, 3.502571331025584*^9, {3.504489482284815*^9, 
   3.5044894832348166`*^9}, {3.504634821600865*^9, 3.504634821860865*^9}, {
   3.506273911643792*^9, 3.506273911643792*^9}, {3.5133076788504677`*^9, 
   3.513307704418913*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.5095533946779337`*^9, 3.509553415627963*^9}, {3.509553538668135*^9, 
   3.5095535518681536`*^9}, {3.5095535889582057`*^9, 
   3.5095536266082582`*^9}, {3.5101725552067585`*^9, 
   3.5101725573127623`*^9}, {3.5101728674101067`*^9, 
   3.5101728711385136`*^9}, {3.510173662715104*^9, 3.510173677129529*^9}, 
   3.5102536435885286`*^9, {3.513292062852798*^9, 3.513292242867111*^9}, {
   3.5132923801169157`*^9, 3.5132923861569242`*^9}, {3.5133078016694837`*^9, 
   3.513307826270727*^9}, 3.5133079022116604`*^9, {3.513308898949012*^9, 
   3.513308902786618*^9}, 3.5133089333938723`*^9, 3.5133091790943036`*^9, {
   3.5151873046098833`*^9, 3.5151873053198843`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "A"}], "-", 
       RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
      "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "B", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "+", 
      RowBox[{"a", "*", "A", "*", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.501971659393694*^9, 3.501971664413701*^9}, {
   3.501971793703882*^9, 3.5019718249239254`*^9}, 3.501972491784859*^9, {
   3.5019828140730867`*^9, 3.5019828147430873`*^9}, 3.501983125183522*^9, {
   3.502147836680137*^9, 3.5021478404901423`*^9}, 3.5022114375309563`*^9, {
   3.5023115961368637`*^9, 3.5023115965892644`*^9}, {3.5023429006790886`*^9, 
   3.5023429061078978`*^9}, 3.5023433992091637`*^9, {3.5024185735523543`*^9, 
   3.502418590652378*^9}, {3.502569097477068*^9, 3.5025691017514753`*^9}, {
   3.502571267995496*^9, 3.5025712820055156`*^9}, 3.5025748095674887`*^9, 
   3.503339105901963*^9, {3.5051562096868563`*^9, 3.505156210426858*^9}, 
   3.5133076275731783`*^9, {3.5133077285521555`*^9, 3.5133077641358175`*^9}, 
   3.5133090638725014`*^9, {3.513309110859784*^9, 3.513309149719452*^9}, {
   3.5133092575312414`*^9, 3.51330926241405*^9}, 3.516820845386727*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 6 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
    FractionBox[
     RowBox[{"k", "+", "3"}], "2"]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, {3.5023426962407293`*^9, 
   3.502342703978343*^9}, {3.5133075416482267`*^9, 3.5133075424594283`*^9}, {
   3.5133089781191506`*^9, 3.513308989663171*^9}, {3.5138852761245832`*^9, 
   3.513885277984586*^9}}],

Cell[TextData[{
 "Rule 12b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"b", " ", "A"}], "-", 
         RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "3"}], "2"]}]}], "=", 
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{"n", "\[LessEqual]", 
        RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"b", " ", "B", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "+", 
         RowBox[{"a", " ", "A", " ", "n"}]}], "\[NotEqual]", "0"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.501972517524895*^9, 3.5019725276349096`*^9}, {
   3.5019829062432156`*^9, 3.5019829076332173`*^9}, {3.5023429280727367`*^9, 
   3.502342934016347*^9}, {3.502419169213188*^9, 3.5024191822832065`*^9}, {
   3.502569156632372*^9, 3.5025691625135818`*^9}, 3.5025712579454823`*^9, {
   3.504489486634821*^9, 3.504489488264823*^9}, {3.504634824610869*^9, 
   3.50463482492087*^9}, {3.5062738990077696`*^9, 3.5062738990077696`*^9}, {
   3.513307681580473*^9, 3.513307709036521*^9}, {3.5152838104352093`*^9, 
   3.5152838119552116`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "B", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "+", 
     RowBox[{"a", " ", "A", " ", "n"}]}], 
    RowBox[{
     SuperscriptBox["a", "2"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.5095533946779337`*^9, 3.509553415627963*^9}, {3.509553538668135*^9, 
   3.5095535518681536`*^9}, {3.5095535889582057`*^9, 
   3.5095536266082582`*^9}, {3.5101725552067585`*^9, 
   3.5101725573127623`*^9}, {3.5101728674101067`*^9, 
   3.5101728711385136`*^9}, {3.510173662715104*^9, 3.510173677129529*^9}, 
   3.5102536435885286`*^9, {3.513292062852798*^9, 3.513292242867111*^9}, {
   3.5132923801169157`*^9, 3.5132923861569242`*^9}, {3.5133078016694837`*^9, 
   3.513307826270727*^9}, 3.5133079022116604`*^9, {3.513308898949012*^9, 
   3.513308902786618*^9}, 3.5133089333938723`*^9, {3.5151873087998896`*^9, 
   3.515187310459892*^9}, 3.5159764287787147`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "B", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "+", 
         RowBox[{"a", "*", "A", "*", "n"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "B", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "+", 
      RowBox[{"a", "*", "A", "*", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.501971659393694*^9, 3.501971664413701*^9}, {
   3.501971793703882*^9, 3.5019718249239254`*^9}, 3.501972491784859*^9, {
   3.5019828140730867`*^9, 3.5019828147430873`*^9}, 3.501983125183522*^9, {
   3.502147836680137*^9, 3.5021478404901423`*^9}, 3.5022114375309563`*^9, {
   3.5023115961368637`*^9, 3.5023115965892644`*^9}, {3.5023429006790886`*^9, 
   3.5023429061078978`*^9}, 3.5023433992091637`*^9, {3.5024185735523543`*^9, 
   3.502418590652378*^9}, {3.502569097477068*^9, 3.5025691017514753`*^9}, {
   3.502571267995496*^9, 3.5025712820055156`*^9}, 3.5025748095674887`*^9, 
   3.503339105901963*^9, {3.5051562096868563`*^9, 3.505156210426858*^9}, 
   3.5133076275731783`*^9, {3.5133077285521555`*^9, 3.5133077641358175`*^9}, 
   3.5133090638725014`*^9, {3.5152838057752028`*^9, 3.515283807395205*^9}, 
   3.516820845426727*^9, 3.516823738559149*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "7"}], "-", "8"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, 3.5107929120112553`*^9, {
   3.510864363862485*^9, 3.5108643733624983`*^9}, 3.513605913762121*^9, 
   3.513795251900381*^9, {3.513805960417873*^9, 3.5138059633160386`*^9}, {
   3.5138258045061316`*^9, 3.513825826175371*^9}, {3.513885462054844*^9, 
   3.5138854624148445`*^9}, {3.5151870060894656`*^9, 3.515187008599469*^9}, {
   3.5151870585395393`*^9, 3.515187061069543*^9}, 3.516582344271842*^9, 
   3.5165823745618844`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 2 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]],
 " ",
 "and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "B", " ", "n"}], "+", 
    RowBox[{"b", " ", "A", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.501808030072035*^9, 3.5018080306804357`*^9}, {3.501909079250301*^9, 
   3.501909086847514*^9}, {3.5133099245420136`*^9, 3.5133099250412145`*^9}, {
   3.513310723466217*^9, 3.5133107306578293`*^9}, {3.513885200364477*^9, 
   3.5138852036044817`*^9}, {3.5165810816000743`*^9, 3.516581083910077*^9}, {
   3.5165816754409056`*^9, 3.5165817059509487`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"a", " ", "B", " ", "n"}], "+", 
       RowBox[{"b", " ", "A", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}]}], "=", "0"}]}]}]]],
 " , then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018083840990562`*^9, 
   3.5018084166251135`*^9}, {3.501909321191126*^9, 3.5019093296931405`*^9}, {
   3.5019839735447097`*^9, 3.5019839735447097`*^9}, {3.5023141785029993`*^9, 
   3.502314184165809*^9}, {3.5044889120340166`*^9, 3.504488913014018*^9}, {
   3.5044895507549105`*^9, 3.504489551014911*^9}, 3.5046347745607986`*^9, 
   3.504639967338069*^9, {3.504640184428373*^9, 3.504640184428373*^9}, {
   3.504642080291027*^9, 3.504642107451065*^9}, {3.5136572146507573`*^9, 
   3.5136572345207853`*^9}, {3.515020577353009*^9, 3.5150206093718405`*^9}, {
   3.516581087830083*^9, 3.5165810976000967`*^9}, {3.5165819068812294`*^9, 
   3.516581935181269*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    FractionBox[
     RowBox[{"k", "-", "1"}], "2"]], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"B", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         FractionBox[
          RowBox[{"k", "-", "1"}], "2"]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.5018080658428974`*^9, 3.501808079789322*^9}, {3.5018081845435057`*^9, 
   3.501808206165144*^9}, {3.5018082365851974`*^9, 3.501808240376004*^9}, {
   3.5019090910439215`*^9, 3.501909180416478*^9}, {3.5019092487601986`*^9, 
   3.501909263205824*^9}, {3.513310738333043*^9, 3.5133107581450777`*^9}, {
   3.5136563411395345`*^9, 3.5136563434595375`*^9}, {3.5151868255592127`*^9, 
   3.5151868309792204`*^9}, {3.5165811299001417`*^9, 3.516581145900164*^9}, {
   3.516581246990306*^9, 3.516581253790315*^9}, {3.5165819481812873`*^9, 
   3.5165819493712893`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "B"}], "*", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", "n"}], "+", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 3.5018079845979548`*^9}, 
   3.501808368327429*^9, {3.5018084216015224`*^9, 3.501808427217532*^9}, {
   3.501819528072632*^9, 3.50181953253424*^9}, {3.5018203432520638`*^9, 
   3.501820344032065*^9}, {3.501881265548032*^9, 3.5018812668180337`*^9}, 
   3.5019094303913174`*^9, {3.5019094896870213`*^9, 3.5019094990938377`*^9}, 
   3.501909788474346*^9, {3.501952314796136*^9, 3.5019523154061365`*^9}, {
   3.50195238883624*^9, 3.501952414636276*^9}, {3.5023141622789707`*^9, 
   3.5023141666469784`*^9}, 3.504640147588321*^9, {3.505156055586641*^9, 
   3.5051560561666417`*^9}, {3.513310809921569*^9, 3.5133108268631983`*^9}, {
   3.513443376187376*^9, 3.5134433763373766`*^9}, {3.5136568597602606`*^9, 
   3.51365687359028*^9}, {3.513656910050331*^9, 3.5136569129003353`*^9}, {
   3.515020222395707*^9, 3.5150202815780916`*^9}, {3.5150203401634426`*^9, 
   3.51502035410324*^9}, {3.515020430528611*^9, 3.515020436192935*^9}, {
   3.515020525289031*^9, 3.51502052894024*^9}, {3.5152795782802167`*^9, 
   3.5152795811002207`*^9}, {3.516581465630612*^9, 3.5165814698006177`*^9}, {
   3.5165818744111843`*^9, 3.5165818770611877`*^9}, {3.5165821808816133`*^9, 
   3.5165822123316574`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "B"}], "*", 
    RowBox[{"Cot", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", "n"}], "+", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, {3.513656934580365*^9, 3.513656989690442*^9}, {
   3.513657056540536*^9, 3.5136570847905755`*^9}, {3.5136572776408453`*^9, 
   3.513657278700847*^9}, 3.513795095427431*^9, {3.5137954552880135`*^9, 
   3.513795485066717*^9}, {3.5137955829433155`*^9, 3.513795587814594*^9}, {
   3.5137956180853252`*^9, 3.513795623374628*^9}, 3.5137961784413757`*^9, {
   3.513827395351123*^9, 3.513827415218259*^9}, 3.5138275127858396`*^9, {
   3.5138275631707215`*^9, 3.513827566729925*^9}, {3.513829965740141*^9, 
   3.513829969961382*^9}, {3.5138301369789352`*^9, 3.513830137428961*^9}, 
   3.5138303049595428`*^9, 3.513886650586508*^9, 3.5138867982067146`*^9, 
   3.515016876666342*^9, {3.5150169826464033`*^9, 3.515016985675577*^9}, {
   3.5151871581296787`*^9, 3.5151871625596848`*^9}, {3.5165815048706665`*^9, 
   3.5165815154706817`*^9}, {3.516581882171195*^9, 3.5165818841011972`*^9}, {
   3.51658207146146*^9, 3.5165821117315164`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 1 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, 3.501812856554513*^9, {3.5133099194408045`*^9, 
   3.513309919659205*^9}, {3.513310110853141*^9, 3.5133101170463514`*^9}, {
   3.513310642314874*^9, 3.5133106436252766`*^9}, {3.513885170224435*^9, 
   3.513885172824439*^9}, {3.5165805460593243`*^9, 3.516580562629348*^9}}],

Cell[TextData[{
 "Rule 7: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{"n", "\[LessEqual]", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", "B", " ", "n"}], "+", 
       RowBox[{"b", " ", "A", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], "\[NotEqual]", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, 3.501812773952368*^9, {
   3.5018130124143867`*^9, 3.501813024192407*^9}, {3.5019838990946054`*^9, 
   3.5019838990946054`*^9}, {3.502313537248273*^9, 3.502313540056278*^9}, {
   3.5032786865960426`*^9, 3.5032786865960426`*^9}, {3.5044889074240103`*^9, 
   3.5044889083740115`*^9}, {3.5044895485049076`*^9, 3.504489548704908*^9}, 
   3.504634772030795*^9, {3.5046385957061486`*^9, 3.504638598326152*^9}, {
   3.5046401693283515`*^9, 3.50464017514836*^9}, {3.513608365525629*^9, 
   3.513608365525629*^9}, 3.5136563676795716`*^9, {3.51365715249067*^9, 
   3.5136571548506737`*^9}, {3.516580809709694*^9, 3.5165808219197106`*^9}, {
   3.5165888909288445`*^9, 3.5165888916588454`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         FractionBox[
          RowBox[{"k", "-", "1"}], "2"]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "B", " ", "n"}], "+", 
     RowBox[{"b", " ", "A", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}]}], 
    RowBox[{"a", " ", "b", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.513277045993078*^9, 3.5132771366732054`*^9}, {3.5132772238133273`*^9, 
   3.5132772240033274`*^9}, {3.513277256793373*^9, 3.513277286693415*^9}, 
   3.513277413733593*^9, {3.51330998524172*^9, 3.513310050184634*^9}, {
   3.5133101228963623`*^9, 3.5133101670756397`*^9}, {3.5133102640142097`*^9, 
   3.513310371139598*^9}, {3.5136563252795124`*^9, 3.5136563276995153`*^9}, {
   3.5151867442090993`*^9, 3.5151867502591076`*^9}, 3.5165805874793825`*^9, {
   3.516580641599458*^9, 3.51658065009947*^9}, {3.5165806845495186`*^9, 
   3.516580708119551*^9}, 3.516580995399954*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "A"}], "-", 
       RowBox[{"a", "*", "B"}]}], ")"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "B", "*", "n"}], "+", 
         RowBox[{"b", "*", "A", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", "n"}], "+", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018131102889585`*^9, 3.501813151972232*^9}, {
   3.501813189599498*^9, 3.501813190332699*^9}, 3.5018608913295975`*^9, {
   3.501881991209048*^9, 3.5018819919590487`*^9}, 3.501983907934618*^9, {
   3.5023135306806617`*^9, 3.502313531320263*^9}, 3.502313932521767*^9, {
   3.50327869079245*^9, 3.5032786910264506`*^9}, 3.50328228357796*^9, {
   3.504638590276141*^9, 3.504638590506141*^9}, 3.5046397563877735`*^9, {
   3.504640119538282*^9, 3.504640131848299*^9}, {3.5051560518666353`*^9, 
   3.5051560525466366`*^9}, {3.513310388939229*^9, 3.513310421964487*^9}, {
   3.513608369566036*^9, 3.5136083698936367`*^9}, {3.513656455929695*^9, 
   3.5136564647497077`*^9}, {3.516588770868676*^9, 3.516588772118678*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "A"}], "-", 
       RowBox[{"a", "*", "B"}]}], ")"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "B", "*", "n"}], "+", 
         RowBox[{"b", "*", "A", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", "n"}], "+", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, {3.513656934580365*^9, 3.513656989690442*^9}, {
   3.513657056540536*^9, 3.5136570847905755`*^9}, {3.5136572776408453`*^9, 
   3.513657278700847*^9}, 3.513795095427431*^9, {3.5137954552880135`*^9, 
   3.513795485066717*^9}, {3.5137955829433155`*^9, 3.513795587814594*^9}, {
   3.5137956180853252`*^9, 3.513795623374628*^9}, 3.5137961784413757`*^9, {
   3.513827395351123*^9, 3.513827415218259*^9}, 3.5138275127858396`*^9, {
   3.5138275631707215`*^9, 3.513827566729925*^9}, {3.5138299127241087`*^9, 
   3.513829956694623*^9}, 3.513830034140053*^9, {3.5138300963736124`*^9, 
   3.5138300985147347`*^9}, 3.5138866491065054`*^9, 3.5138867969167123`*^9, {
   3.515187149649667*^9, 3.515187154139673*^9}, {3.5165809098998337`*^9, 
   3.51658092160985*^9}, {3.5165818053610873`*^9, 3.516581837171132*^9}, {
   3.5165883848068953`*^9, 3.516588386023698*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 2 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.501808030072035*^9, 3.5018080306804357`*^9}, {3.501909079250301*^9, 
   3.501909086847514*^9}, {3.5133099245420136`*^9, 3.5133099250412145`*^9}, {
   3.513310723466217*^9, 3.5133107306578293`*^9}, {3.513885200364477*^9, 
   3.5138852036044817`*^9}, {3.5165810816000743`*^9, 3.516581083910077*^9}}],

Cell[TextData[{
 "Rule 8: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{"n", ">", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", "B", " ", "n"}], "+", 
       RowBox[{"b", " ", "A", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], "\[NotEqual]", "0"}]}]}]}]]],
 " , then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018083840990562`*^9, 
   3.5018084166251135`*^9}, {3.501909321191126*^9, 3.5019093296931405`*^9}, {
   3.5019839735447097`*^9, 3.5019839735447097`*^9}, {3.5023141785029993`*^9, 
   3.502314184165809*^9}, {3.5044889120340166`*^9, 3.504488913014018*^9}, {
   3.5044895507549105`*^9, 3.504489551014911*^9}, 3.5046347745607986`*^9, 
   3.504639967338069*^9, {3.504640184428373*^9, 3.504640184428373*^9}, {
   3.504642080291027*^9, 3.504642107451065*^9}, {3.5136572146507573`*^9, 
   3.5136572345207853`*^9}, {3.515020577353009*^9, 3.5150206093718405`*^9}, {
   3.516581087830083*^9, 3.5165810976000967`*^9}, {3.5165888639388065`*^9, 
   3.5165888651088085`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "B", " ", "n"}], "+", 
     RowBox[{"b", " ", "A", " ", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}]}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", " ", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.5018080658428974`*^9, 3.501808079789322*^9}, {3.5018081845435057`*^9, 
   3.501808206165144*^9}, {3.5018082365851974`*^9, 3.501808240376004*^9}, {
   3.5019090910439215`*^9, 3.501909180416478*^9}, {3.5019092487601986`*^9, 
   3.501909263205824*^9}, {3.513310738333043*^9, 3.5133107581450777`*^9}, {
   3.5136563411395345`*^9, 3.5136563434595375`*^9}, {3.5151868255592127`*^9, 
   3.5151868309792204`*^9}, {3.5165811299001417`*^9, 3.516581145900164*^9}, {
   3.516581246990306*^9, 3.516581253790315*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "B", "*", "n"}], "+", 
         RowBox[{"b", "*", "A", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", "n"}], "+", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 3.5018079845979548`*^9}, 
   3.501808368327429*^9, {3.5018084216015224`*^9, 3.501808427217532*^9}, {
   3.501819528072632*^9, 3.50181953253424*^9}, {3.5018203432520638`*^9, 
   3.501820344032065*^9}, {3.501881265548032*^9, 3.5018812668180337`*^9}, 
   3.5019094303913174`*^9, {3.5019094896870213`*^9, 3.5019094990938377`*^9}, 
   3.501909788474346*^9, {3.501952314796136*^9, 3.5019523154061365`*^9}, {
   3.50195238883624*^9, 3.501952414636276*^9}, {3.5023141622789707`*^9, 
   3.5023141666469784`*^9}, 3.504640147588321*^9, {3.505156055586641*^9, 
   3.5051560561666417`*^9}, {3.513310809921569*^9, 3.5133108268631983`*^9}, {
   3.513443376187376*^9, 3.5134433763373766`*^9}, {3.5136568597602606`*^9, 
   3.51365687359028*^9}, {3.513656910050331*^9, 3.5136569129003353`*^9}, {
   3.515020222395707*^9, 3.5150202815780916`*^9}, {3.5150203401634426`*^9, 
   3.51502035410324*^9}, {3.515020430528611*^9, 3.515020436192935*^9}, {
   3.515020525289031*^9, 3.51502052894024*^9}, {3.5152795782802167`*^9, 
   3.5152795811002207`*^9}, {3.516581465630612*^9, 3.5165814698006177`*^9}, 
   3.5165888581087985`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "B", "*", "n"}], "+", 
         RowBox[{"b", "*", "A", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "B", "*", "n"}], "+", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, {3.513656934580365*^9, 3.513656989690442*^9}, {
   3.513657056540536*^9, 3.5136570847905755`*^9}, {3.5136572776408453`*^9, 
   3.513657278700847*^9}, 3.513795095427431*^9, {3.5137954552880135`*^9, 
   3.513795485066717*^9}, {3.5137955829433155`*^9, 3.513795587814594*^9}, {
   3.5137956180853252`*^9, 3.513795623374628*^9}, 3.5137961784413757`*^9, {
   3.513827395351123*^9, 3.513827415218259*^9}, 3.5138275127858396`*^9, {
   3.5138275631707215`*^9, 3.513827566729925*^9}, {3.513829965740141*^9, 
   3.513829969961382*^9}, {3.5138301369789352`*^9, 3.513830137428961*^9}, 
   3.5138303049595428`*^9, 3.513886650586508*^9, 3.5138867982067146`*^9, 
   3.515016876666342*^9, {3.5150169826464033`*^9, 3.515016985675577*^9}, {
   3.5151871581296787`*^9, 3.5151871625596848`*^9}, {3.5165815048706665`*^9, 
   3.5165815154706817`*^9}, {3.51658175717102*^9, 3.5165817804710526`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "1"}], "-", "6"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, {3.504416834825964*^9, 3.50441685330599*^9}, {
   3.5044169074260654`*^9, 3.504416914836076*^9}, {3.504466654444235*^9, 
   3.504466654664235*^9}, {3.5053446909738536`*^9, 3.5053446909738536`*^9}, {
   3.509895545887774*^9, 3.5098955477129774`*^9}, 3.5100196487192698`*^9, 
   3.5101738434258213`*^9, {3.512080349338236*^9, 3.512080349518236*^9}, {
   3.5151873365999284`*^9, 3.5151873374999294`*^9}, {3.5151873939000087`*^9, 
   3.5151874016700196`*^9}, {3.515283194884348*^9, 3.5152831970843506`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Recurrence 7", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017224385660048`*^9, 3.5017224419824104`*^9}, 3.5017229574385157`*^9, 
   3.501723447987378*^9, {3.504905059830614*^9, 3.5049051008006716`*^9}, {
   3.5049062442122726`*^9, 3.5049062459122753`*^9}, 3.505345087554409*^9, 
   3.5120642138723326`*^9, {3.513276979592985*^9, 3.513276981292988*^9}, {
   3.5147754897687864`*^9, 3.5147754924207907`*^9}, {3.515187407180027*^9, 
   3.5151874102100315`*^9}}],

Cell[TextData[{
 "Rule 1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], ">", "0"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501357957382189*^9, 3.50135795852219*^9}, {3.501358112502406*^9, 
   3.501358113912408*^9}, 3.501358177622497*^9, {3.501358226452565*^9, 
   3.50135822974257*^9}, 3.5013587175532527`*^9, {3.501359477874317*^9, 
   3.5013594968243437`*^9}, {3.5013598992049074`*^9, 3.501359907704919*^9}, {
   3.5027643770807753`*^9, 3.502764379015179*^9}, {3.5027682951140594`*^9, 
   3.5027682985460653`*^9}, {3.5040444264213743`*^9, 
   3.5040444272313757`*^9}, {3.504051718871584*^9, 3.5040517366516085`*^9}, {
   3.5041205238947134`*^9, 3.5041205286947203`*^9}, 3.504313308494599*^9, {
   3.504468281906513*^9, 3.504468310686553*^9}, 3.5047593049489765`*^9, {
   3.504906162322158*^9, 3.5049061627021585`*^9}, {3.5049064428125505`*^9, 
   3.5049064506925616`*^9}, {3.50533260661224*^9, 3.5053326074722414`*^9}, 
   3.509560858337617*^9, {3.5095625023699183`*^9, 3.509562503079919*^9}, {
   3.5101727198650475`*^9, 3.5101727198650475`*^9}, {3.510179319617087*^9, 
   3.510179320131888*^9}, {3.510961172200745*^9, 3.510961242840844*^9}, {
   3.511721203714892*^9, 3.511721203714892*^9}, {3.5121535943316607`*^9, 
   3.5121535948816614`*^9}, {3.5121868707099905`*^9, 
   3.5121868707099905`*^9}, {3.513121343771776*^9, 3.513121343771776*^9}, 
   3.5132777505440645`*^9, {3.513277788074117*^9, 3.513277788074117*^9}, {
   3.51329339747834*^9, 3.513293430888387*^9}, {3.5137066287676473`*^9, 
   3.5137066287676473`*^9}, {3.513707111276495*^9, 3.5137071125712967`*^9}, {
   3.5137083405334544`*^9, 3.5137083405334544`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "-", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", " ", "A"}], "-", 
            RowBox[{"a", " ", "B"}]}], ")"}]}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B", " ", "n"}], "+", 
           RowBox[{"a", " ", "A", " ", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "-", 
              RowBox[{"b", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.513277045993078*^9, 3.5132771366732054`*^9}, {3.5132772238133273`*^9, 
   3.5132772240033274`*^9}, {3.513277256793373*^9, 3.513277286693415*^9}, 
   3.513277413733593*^9, {3.515187338239931*^9, 3.5151873412199345`*^9}, 
   3.5159764954220314`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.509479967012754*^9, 3.5094799793114576`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "A"}], "-", 
       RowBox[{"a", "*", "B"}]}], ")"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"b", "*", "A"}], "-", 
                RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "B", "*", "n"}], "+", 
               RowBox[{"a", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"a", "*", "A"}], "-", 
                  RowBox[{"b", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"j", "*", "k", "*", "m"}], "\[Equal]", "1"}], " ", "&&", " ", 
      RowBox[{"n", "\[Equal]", 
       RowBox[{"-", "1"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.5095612456781588`*^9, 3.5095612748082*^9}, 
   3.5095620502492857`*^9, {3.510172404058093*^9, 3.5101724092061024`*^9}, {
   3.5101724458193665`*^9, 3.510172460951393*^9}, 3.510172592319224*^9, {
   3.510172636950902*^9, 3.5101726399773073`*^9}, 3.510179325857098*^9, 
   3.5101800555639796`*^9, {3.510960394235654*^9, 3.5109604170256853`*^9}, {
   3.510961297750921*^9, 3.5109613190309505`*^9}, 3.510961446411129*^9, {
   3.5121851888858356`*^9, 3.512185189806237*^9}, 3.513121332149756*^9, 
   3.5132775489837823`*^9, 3.513277721644024*^9, {3.5132934633784323`*^9, 
   3.513293481838458*^9}, 3.5134454715303097`*^9, {3.5137066356628594`*^9, 
   3.5137066358188596`*^9}, {3.5137071069084873`*^9, 
   3.5137071082032895`*^9}, {3.5147754824679737`*^9, 3.514775553323298*^9}, {
   3.5147759319827633`*^9, 3.5147759354303694`*^9}, {3.5147760488425684`*^9, 
   3.5147760515413733`*^9}, {3.514777602898498*^9, 3.514777608576908*^9}, {
   3.5147778079608583`*^9, 3.5147778159480724`*^9}, {3.51478396531174*^9, 
   3.5147839984617987`*^9}, {3.514785323699726*^9, 3.514785326663731*^9}, {
   3.5147857760069203`*^9, 3.5147857835417337`*^9}, {3.5152814335114155`*^9, 
   3.5152814368654213`*^9}, {3.5152819625826225`*^9, 3.515281970292633*^9}, {
   3.515282253173029*^9, 3.5152822956430883`*^9}, {3.515282356643174*^9, 
   3.5152823678331895`*^9}, {3.515282471923335*^9, 3.515282481663349*^9}, {
   3.5152831111642303`*^9, 3.5152831119542313`*^9}, 3.5168208456867275`*^9, 
   3.516823738569149*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Recurrence 8", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.501722843012315*^9, 3.501722843651916*^9}, 
   3.505345104394432*^9, 3.51206422619235*^9, {3.513277905884282*^9, 
   3.513277908974286*^9}}],

Cell[TextData[{
 "Rule 2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], ">", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "n", "<", "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5027682258967376`*^9, 
   3.502768240248763*^9}, 3.502768355688966*^9, {3.5033578653664684`*^9, 
   3.50335786655207*^9}, {3.5033582359295187`*^9, 3.5033582359295187`*^9}, {
   3.5040444363813887`*^9, 3.5040444374213896`*^9}, {3.5040517955416913`*^9, 
   3.5040517955416913`*^9}, {3.5041423703555098`*^9, 3.504142372414714*^9}, {
   3.5041598902074847`*^9, 3.5041598902074847`*^9}, 3.5043133121446037`*^9, {
   3.5095605626772027`*^9, 3.5095605681672106`*^9}, {3.5101727225170527`*^9, 
   3.5101727225170527`*^9}, {3.5101793335947113`*^9, 3.510179334015912*^9}, {
   3.510961549121273*^9, 3.5109615587012863`*^9}, {3.51096210431205*^9, 
   3.51096210431205*^9}, {3.511721241874945*^9, 3.511721241874945*^9}, {
   3.512186891317627*^9, 3.512186891317627*^9}, {3.513277915104295*^9, 
   3.513277915104295*^9}, {3.513293509328497*^9, 3.5132935424385433`*^9}, {
   3.5136428011786947`*^9, 3.5136428100687075`*^9}, {3.5137068613640556`*^9, 
   3.5137068640784607`*^9}, {3.513707234204711*^9, 3.513707234204711*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "-", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B", " ", "n"}], "+", 
           RowBox[{"a", " ", "A", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5095601616466413`*^9, 3.509560314986856*^9}, {
   3.509560348756903*^9, 3.50956035327691*^9}, {3.51017248196463*^9, 
   3.5101724878458405`*^9}, {3.5101727624843225`*^9, 3.510172767367131*^9}, {
   3.5101731141401405`*^9, 3.510173160207021*^9}, {3.5132779318843184`*^9, 
   3.513277940724331*^9}, {3.5132779893043985`*^9, 3.5132780561744924`*^9}, {
   3.513278092324543*^9, 3.513278109504567*^9}, 3.513278174804659*^9, {
   3.5132782333547406`*^9, 3.5132782367547455`*^9}, {3.515187344469939*^9, 
   3.5151873464799423`*^9}, {3.5151874180300426`*^9, 3.515187418440043*^9}, {
   3.5159765569017396`*^9, 3.515976557790941*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "B", "*", "n"}], "+", 
               RowBox[{"a", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "n", "<", "0"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"j", "*", "m"}], "\[Equal]", "1"}], " ", "&&", " ", 
      RowBox[{"k", "\[Equal]", "1"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, {
   3.5095604119769917`*^9, 3.5095604408470325`*^9}, 3.5099006613518543`*^9, 
   3.5101725950180283`*^9, {3.510172650132925*^9, 3.5101726506789265`*^9}, {
   3.510172769831936*^9, 3.510172774636744*^9}, 3.510173007264353*^9, 
   3.5101730481208243`*^9, {3.5101731721098423`*^9, 3.510173214229916*^9}, 
   3.510179337744319*^9, 3.5101800644715953`*^9, {3.5109614826411796`*^9, 
   3.510961489201189*^9}, 3.510962096552039*^9, 3.512185231926311*^9, 
   3.5132775492237825`*^9, 3.513278375204939*^9, {3.5132935924986134`*^9, 
   3.513293603558629*^9}, 3.513445488380333*^9, {3.5136427611686387`*^9, 
   3.5136427862186737`*^9}, {3.5137068166855774`*^9, 3.513706821786786*^9}, {
   3.5137071588565784`*^9, 3.5137071594181795`*^9}, 3.5150079377730665`*^9, 
   3.5168208457167273`*^9, 3.5168237385901504`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Recurrence 9", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, 
   3.505345123294459*^9, 3.5120642383523664`*^9, {3.5132784319350185`*^9, 
   3.5132784361650248`*^9}}],

Cell[TextData[{
 "Note: In the case ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]],
 ", this rule simplifies to rule 10."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, 
   3.505345123294459*^9, 3.5120642383523664`*^9, {3.5132784319350185`*^9, 
   3.5132784361650248`*^9}, {3.5137079232171216`*^9, 
   3.5137080163648853`*^9}, {3.515196042405034*^9, 3.5151960448074384`*^9}}],

Cell[TextData[{
 "Rule 3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[NotEqual]", 
       FractionBox["1", "2"]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4993685152127995`*^9, 3.499368525272814*^9}, {3.5003196739046497`*^9, 
   3.5003196775646553`*^9}, {3.5004320218638687`*^9, 
   3.5004320229179287`*^9}, {3.5026773276717095`*^9, 
   3.5026773598217545`*^9}, {3.5027672801246758`*^9, 
   3.5027672801246758`*^9}, {3.5040286397141275`*^9, 
   3.5040286407749295`*^9}, {3.5040290157527885`*^9, 3.5040290170787907`*^9}, 
   3.5040318675893974`*^9, {3.504296981415786*^9, 3.5042969896257973`*^9}, 
   3.5043107563112917`*^9, {3.5047476042825956`*^9, 3.5047476056225977`*^9}, {
   3.5051011018466954`*^9, 3.5051011152867146`*^9}, {3.5094725039578915`*^9, 
   3.5094725039578915`*^9}, 3.509556239034717*^9, {3.5099022313560534`*^9, 
   3.5099022313560534`*^9}, {3.510172725153457*^9, 3.510172725153457*^9}, {
   3.5101793423307266`*^9, 3.5101793427675276`*^9}, {3.5117212484449544`*^9, 
   3.5117212484449544`*^9}, {3.512186902268846*^9, 3.512186903111247*^9}, {
   3.51327843988503*^9, 3.5132784474350405`*^9}, {3.5132936508786955`*^9, 
   3.5132936650787153`*^9}, {3.5137073124544477`*^9, 
   3.5137073124544477`*^9}, {3.51370737594656*^9, 3.51370737594656*^9}, {
   3.513707523600819*^9, 3.513707531837633*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "A", " ", "n"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "+", 
           RowBox[{"b", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "+", 
           RowBox[{"a", " ", "B", " ", "n"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "+", 
              RowBox[{"a", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
              FractionBox[
               RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.513278609965268*^9, 3.513278645275317*^9}, {3.513278681485368*^9, 
   3.513278702895398*^9}, 3.513278843665595*^9, {3.515187351099949*^9, 
   3.515187352819951*^9}, 3.515976581518583*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}, {
   3.509557000785784*^9, 3.5095570051957893`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "B", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", "n"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "+", 
               RowBox[{"b", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "+", 
               RowBox[{"a", "*", "B", "*", "n"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "+", 
                  RowBox[{"a", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"1", "/", "2"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"j", "*", "m"}], "\[Equal]", "1"}], " ", "&&", " ", 
      RowBox[{"k", "\[Equal]", "1"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, 
   3.5095570491158514`*^9, {3.5095604499870453`*^9, 3.5095604530970497`*^9}, 
   3.509843216812952*^9, 3.509902227726048*^9, 3.510172597685633*^9, {
   3.5101726543449326`*^9, 3.5101726549065337`*^9}, {3.510172783045159*^9, 
   3.510172787787567*^9}, 3.5101730101503572`*^9, 3.51017304548442*^9, {
   3.5101732486279764`*^9, 3.5101732629176016`*^9}, 3.5101793461995335`*^9, {
   3.5121852599595604`*^9, 3.512185262127964*^9}, 3.5132775494437833`*^9, 
   3.513278957825755*^9, {3.513293685188743*^9, 3.513293685408744*^9}, {
   3.513573157862776*^9, 3.5135731718404007`*^9}, {3.5137073370400915`*^9, 
   3.513707339411296*^9}, {3.5137074115926223`*^9, 3.513707413371025*^9}, {
   3.5137075129772005`*^9, 3.513707517376408*^9}, 3.5137076007429543`*^9, {
   3.514785488514015*^9, 3.514785572785363*^9}, {3.5150024925906954`*^9, 
   3.5150025006507063`*^9}, 3.516820845756727*^9, 3.5168237386121516`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Recurrence 10", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.505866068185237*^9, 3.505866068655238*^9}, 3.5058664962858367`*^9, {
   3.509986401026863*^9, 3.5099864013768635`*^9}, 3.512064224502348*^9, 
   3.5130500758863173`*^9, {3.5132793432762947`*^9, 3.5132793434762945`*^9}}],

Cell[TextData[{
 "Note: In the case ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]],
 ", this rule simplifies to rule 9b."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, 
   3.505345123294459*^9, 3.5120642383523664`*^9, {3.5132784319350185`*^9, 
   3.5132784361650248`*^9}, {3.5137079232171216`*^9, 
   3.5137080163648853`*^9}, {3.5137081208538685`*^9, 
   3.5137081508215213`*^9}, {3.5151960884875154`*^9, 3.515196088815116*^9}}],

Cell[TextData[{
 "Rule 4: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "<", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[NotEqual]", 
       FractionBox["1", "2"]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.504028644986937*^9, 3.5040286460633388`*^9}, 
   3.504031871520604*^9, {3.5042969469757376`*^9, 3.504296966725765*^9}, 
   3.5043107598680983`*^9, {3.504747625602626*^9, 3.5047476267926273`*^9}, {
   3.5051010704066515`*^9, 3.505101092536682*^9}, {3.5094730728464303`*^9, 
   3.5094730728464303`*^9}, {3.5095545822823973`*^9, 
   3.5095545998824224`*^9}, {3.5101727293810644`*^9, 
   3.5101727293810644`*^9}, {3.5101793585079556`*^9, 
   3.5101793589291563`*^9}, {3.5117212591249695`*^9, 
   3.5117212591249695`*^9}, {3.5121869358089046`*^9, 3.512186937088107*^9}, 
   3.5132794143763943`*^9, {3.5132798091269464`*^9, 3.5132798091269464`*^9}, {
   3.5132937204487925`*^9, 3.51329373291881*^9}, {3.513708063040167*^9, 
   3.513708085831807*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", "A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "+", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "+", 
           RowBox[{"a", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "-", 
        RowBox[{"b", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A", " ", "n"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"b", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.515187356869957*^9, 3.5151873589599595`*^9}, 
   3.5159766074458284`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", "A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "+", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "-", 
            RowBox[{"b", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A", "*", "n"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"a", "*", "A"}], "+", 
                  RowBox[{"b", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5095546021524253`*^9, {3.5095604705070734`*^9, 
   3.5095604739670787`*^9}, 3.509901170672567*^9, 3.509901379052859*^9, 
   3.5101726030676427`*^9, {3.5101726631121483`*^9, 3.510172663673749*^9}, {
   3.510172826725236*^9, 3.5101728304380417`*^9}, {3.510173018449572*^9, 
   3.5101730407264113`*^9}, {3.5101733867038193`*^9, 3.510173418621475*^9}, 
   3.5101793621427617`*^9, 3.5105917427974453`*^9, 3.5105925522585783`*^9, {
   3.510784548740075*^9, 3.5107845520472813`*^9}, {3.512185343432107*^9, 
   3.51218534510131*^9}, 3.5132775498937836`*^9, 3.5132797211568236`*^9, {
   3.513293763758853*^9, 3.5132937639588537`*^9}, {3.5137081594015365`*^9, 
   3.5137081716475577`*^9}, 3.516820845796727*^9, 3.516823738634153*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Recurrence 11", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017234466769753`*^9, 3.5053450875744085`*^9, 3.512064250422384*^9, {
   3.513279750786865*^9, 3.513279750986865*^9}}],

Cell[TextData[{
 "Rule 5: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "n", "<", "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, 
   3.501360698386026*^9, 3.502764465517331*^9, {3.502764564717905*^9, 
   3.5027645817219353`*^9}, {3.5040444512814093`*^9, 
   3.5040444521714106`*^9}, {3.504053340593854*^9, 3.504053349543867*^9}, {
   3.504066741697694*^9, 3.504066851700986*^9}, {3.504119823905727*^9, 
   3.504119823905727*^9}, {3.5041479977137966`*^9, 3.5041480034702067`*^9}, {
   3.504148210794571*^9, 3.504148226566199*^9}, {3.5041534502353735`*^9, 
   3.5041534502353735`*^9}, {3.504154534889679*^9, 3.504154536215681*^9}, {
   3.504216285491615*^9, 3.504216285731615*^9}, {3.5042166285920954`*^9, 
   3.504216629042096*^9}, {3.5042972939462233`*^9, 3.504297296396227*^9}, 
   3.504313351644659*^9, {3.5049153219428873`*^9, 3.5049153226136885`*^9}, {
   3.504925576302874*^9, 3.5049255770228753`*^9}, {3.5049308071301975`*^9, 
   3.5049308087401996`*^9}, {3.5049802806771584`*^9, 
   3.5049803320772305`*^9}, {3.5095544314221864`*^9, 
   3.5095544444322042`*^9}, {3.510172731908269*^9, 3.510172731908269*^9}, {
   3.5101793674311705`*^9, 3.5101793678679714`*^9}, {3.511721264494977*^9, 
   3.5117212645049767`*^9}, {3.5121869534213357`*^9, 
   3.5121869534213357`*^9}, {3.513101354846774*^9, 3.5131013674367914`*^9}, {
   3.5132798021169367`*^9, 3.5132798056169415`*^9}, {3.513292029622751*^9, 
   3.5132920298727517`*^9}, {3.5132937823888793`*^9, 
   3.5132937938188953`*^9}, {3.5137082870097604`*^9, 
   3.5137082870097604`*^9}, {3.513810458683159*^9, 3.513810460419258*^9}, {
   3.5138105035707264`*^9, 3.513810520105672*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "+", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "-", 
        RowBox[{"b", " ", "A", " ", "n"}], "+", 
        RowBox[{"a", " ", "A", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095542513719344`*^9, 3.509554323542035*^9}, {3.510172539341531*^9, 
   3.5101725420403357`*^9}, {3.510173494983609*^9, 3.5101735152636447`*^9}, {
   3.5132798504870043`*^9, 3.5132799133070927`*^9}, {3.5132800310872574`*^9, 
   3.5132800316472583`*^9}, {3.5132800984573517`*^9, 
   3.5132801027073574`*^9}, {3.513280379307745*^9, 3.513280408807786*^9}, {
   3.5151873623799644`*^9, 3.5151873644099674`*^9}, 3.515976612749838*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "-", 
            RowBox[{"b", "*", "A", "*", "n"}], "+", 
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, {3.5095542554019403`*^9, 
   3.5095542862019835`*^9}, {3.509554360482087*^9, 3.509554381662117*^9}, 
   3.509554414102162*^9, 3.5101726059536476`*^9, {3.510172667168155*^9, 
   3.5101726677609563`*^9}, {3.510172847083271*^9, 3.510172851123678*^9}, {
   3.510173021787978*^9, 3.510173038386407*^9}, {3.510173532330075*^9, 
   3.5101735756201506`*^9}, 3.510179372235979*^9, 3.510180086077633*^9, 
   3.51059079396611*^9, {3.5105915658871975`*^9, 3.5105915675671997`*^9}, {
   3.510591650907316*^9, 3.5105916535873203`*^9}, {3.5121853535721245`*^9, 
   3.5121853594377356`*^9}, {3.5131013736668005`*^9, 3.5131013937268286`*^9}, 
   3.513277550123784*^9, 3.513280609248067*^9, 3.513293812258921*^9, {
   3.5137082415824804`*^9, 3.5137082491172943`*^9}, {3.513810452270792*^9, 
   3.513810478394286*^9}, 3.516820845836727*^9, 3.516823738657154*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Recurrence 12", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017237232810616`*^9, 3.5017237250750647`*^9}, 
   3.505345123374459*^9, {3.5095533681578965`*^9, 3.509553382797917*^9}, 
   3.512064197212309*^9, {3.51329200683272*^9, 3.5132920085827217`*^9}}],

Cell[TextData[{
 "Rule 6: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "<", "0"}], " ", "\[And]", " ", 
     RowBox[{"n", "\[LessEqual]", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.501358653573163*^9, 3.5013586559531665`*^9}, {
   3.502678432393256*^9, 3.5026784351732597`*^9}, {3.5027657117315207`*^9, 
   3.5027657146955256`*^9}, {3.5027672159617634`*^9, 
   3.5027672159617634`*^9}, {3.503549413750845*^9, 3.5035494378508787`*^9}, {
   3.5040286533797517`*^9, 3.5040286542689533`*^9}, 3.504031878337816*^9, 
   3.5043107701173162`*^9, {3.509475086194587*^9, 3.509475086194587*^9}, 
   3.509553389797927*^9, 3.5095539171114664`*^9, {3.510172737461879*^9, 
   3.510172737461879*^9}, {3.5101793831871986`*^9, 3.5101793836083994`*^9}, {
   3.5117212733849893`*^9, 3.5117212733849893`*^9}, {3.5121869822033863`*^9, 
   3.512186985635392*^9}, {3.5132938497789736`*^9, 3.5132938497789736`*^9}, {
   3.513708328193833*^9, 3.513708329987836*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["b", "2"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "A", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "-", 
           RowBox[{"b", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.5095533946779337`*^9, 3.509553415627963*^9}, {3.509553538668135*^9, 
   3.5095535518681536`*^9}, {3.5095535889582057`*^9, 
   3.5095536266082582`*^9}, {3.5101725552067585`*^9, 
   3.5101725573127623`*^9}, {3.5101728674101067`*^9, 
   3.5101728711385136`*^9}, {3.510173662715104*^9, 3.510173677129529*^9}, 
   3.5102536435885286`*^9, {3.513292062852798*^9, 3.513292242867111*^9}, {
   3.5132923801169157`*^9, 3.5132923861569242`*^9}, {3.515187367729972*^9, 
   3.5151873693899746`*^9}, 3.5159766173518457`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "-", 
               RowBox[{"b", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "-", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.4993638009881725`*^9, {3.4993661760314975`*^9, 3.4993661794315023`*^9}, 
   3.4993699436547995`*^9, 3.499369995914872*^9, {3.5003179814609165`*^9, 
   3.5003179817417173`*^9}, 3.5003186747732515`*^9, {3.5003187057132945`*^9, 
   3.5003187115933027`*^9}, {3.5003194495843363`*^9, 3.500319453664342*^9}, {
   3.5003198135348454`*^9, 3.5003198411248837`*^9}, 3.500320756016165*^9, 
   3.50052634660607*^9, {3.501043281866661*^9, 3.5010432838407745`*^9}, {
   3.501358610383103*^9, 3.5013586217531185`*^9}, {3.5026774770619183`*^9, 
   3.5026774832519274`*^9}, {3.502677757052311*^9, 3.502677762832319*^9}, {
   3.5027656424673986`*^9, 3.502765645119404*^9}, {3.502767123656401*^9, 
   3.502767137805626*^9}, {3.5030718732081084`*^9, 3.503071876548113*^9}, {
   3.503072001488288*^9, 3.5030720017582884`*^9}, {3.5035493869908075`*^9, 
   3.503549399840825*^9}, 3.503555712201664*^9, {3.5051555554059405`*^9, 
   3.5051555560359416`*^9}, {3.5053446414837847`*^9, 3.505344668463822*^9}, 
   3.505344708453878*^9, 3.50535356428522*^9, {3.509474964753641*^9, 
   3.509474975710268*^9}, 3.5094750696026382`*^9, 3.509475101121441*^9, {
   3.509553424017975*^9, 3.509553432967987*^9}, {3.5095534659980335`*^9, 
   3.5095534661880336`*^9}, {3.509553498418079*^9, 3.5095535081080923`*^9}, {
   3.5095536757983274`*^9, 3.509553686398342*^9}, {3.509553719448388*^9, 
   3.509553731888406*^9}, {3.5095537915784893`*^9, 3.5095537991284995`*^9}, 
   3.510172611101657*^9, {3.510172676746572*^9, 3.510172679367377*^9}, {
   3.5101728734005175`*^9, 3.5101728784861264`*^9}, {3.5101736897655516`*^9, 
   3.5101737202168045`*^9}, 3.5101793873368063`*^9, 3.510180094517248*^9, 
   3.5121853971430016`*^9, 3.513277550533785*^9, 3.513292850547575*^9, {
   3.5132938660289965`*^9, 3.5132938662789965`*^9}, {3.51370832100222*^9, 
   3.513708324590226*^9}, {3.5147776443321705`*^9, 3.514777649994981*^9}, {
   3.514777749569956*^9, 3.5147777517851596`*^9}, 3.514777861453352*^9, {
   3.514784007447414*^9, 3.5147840081338153`*^9}, 3.514784157301277*^9, {
   3.5152831364142656`*^9, 3.515283143444276*^9}, 3.5152865094009895`*^9, 
   3.5168208458667274`*^9, 3.5168237386801558`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for (sin^j)^m (A+B sin^k) (a+a sin^k)^n", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.3999998569488525`,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 3438, 75, 157, "Title"],
Cell[CellGroupData[{
Cell[4008, 99, 3495, 57, 54, "Subsubtitle"],
Cell[7506, 158, 5175, 104, 529, "Input"],
Cell[12684, 264, 1554, 26, 278, "Text"],
Cell[14241, 292, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[14322, 298, 3288, 69, 119, "Title"],
Cell[CellGroupData[{
Cell[17635, 371, 2466, 61, 510, "Subsubtitle"],
Cell[20104, 434, 89, 2, 354, "Subsubsection"],
Cell[20196, 438, 546, 8, 243, "Subsubsection"],
Cell[20745, 448, 1116, 30, 394, "Subsubsection"],
Cell[21864, 480, 1025, 19, 261, "Subsubsection"],
Cell[22892, 501, 1779, 33, 261, "Subsubsection"],
Cell[24674, 536, 2202, 54, 638, "Subsubtitle"],
Cell[26879, 592, 771, 11, 354, "Subsubsection"],
Cell[27653, 605, 3402, 86, 1079, "Code"],
Cell[31058, 693, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[31139, 699, 2757, 61, 468, "Subsubtitle"],
Cell[33899, 762, 1282, 24, 261, "Subsubsection"],
Cell[35184, 788, 2184, 40, 187, "Subsubsection"],
Cell[37371, 830, 5395, 120, 916, "Subsubtitle"],
Cell[42769, 952, 771, 11, 253, "Subsubsection"],
Cell[43543, 965, 5123, 135, 1147, "Code"],
Cell[48669, 1102, 89, 2, 253, "Subsubsection"],
Cell[48761, 1106, 1163, 23, 187, "Subsubsection"],
Cell[49927, 1131, 2218, 39, 187, "Subsubsection"],
Cell[52148, 1172, 5282, 109, 879, "Subsubtitle"],
Cell[57433, 1283, 771, 11, 253, "Subsubsection"],
Cell[58207, 1296, 4765, 119, 1147, "Code"],
Cell[62975, 1417, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[63068, 1424, 3462, 75, 119, "Title"],
Cell[CellGroupData[{
Cell[66555, 1503, 4257, 91, 137, "Subsubtitle"],
Cell[70815, 1596, 993, 13, 495, "Subsubsection"],
Cell[71811, 1611, 1827, 53, 956, "Subsubsection"],
Cell[73641, 1666, 2552, 45, 495, "Subsubsection"],
Cell[76196, 1713, 6821, 136, 1296, "Subsubtitle"],
Cell[83020, 1851, 771, 11, 495, "Subsubsection"],
Cell[83794, 1864, 6287, 125, 1882, "Code"],
Cell[90084, 1991, 4254, 104, 2031, "Code"],
Cell[94341, 2097, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[94422, 2103, 4253, 89, 106, "Subsubtitle"],
Cell[98678, 2194, 1088, 15, 495, "Subsubsection"],
Cell[99769, 2211, 2435, 42, 365, "Subsubsection"],
Cell[102207, 2255, 4888, 104, 2164, "Subsubtitle"],
Cell[107098, 2361, 819, 11, 495, "Subsubsection"],
Cell[107920, 2374, 4532, 107, 1882, "Code"],
Cell[112455, 2483, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[112536, 2489, 3177, 61, 88, "Subsubtitle"],
Cell[115716, 2552, 1656, 33, 1300, "Subsubsection"],
Cell[117375, 2587, 2241, 40, 1079, "Subsubsection"],
Cell[119619, 2629, 5581, 112, 4330, "Subsubtitle"],
Cell[125203, 2743, 771, 11, 968, "Subsubsection"],
Cell[125977, 2756, 6065, 134, 3687, "Code"],
Cell[132045, 2892, 89, 2, 968, "Subsubsection"],
Cell[132137, 2896, 993, 13, 664, "Subsubsection"],
Cell[133133, 2911, 1394, 36, 1296, "Subsubsection"],
Cell[134530, 2949, 2455, 47, 1079, "Subsubsection"],
Cell[136988, 2998, 5353, 112, 4199, "Subsubtitle"],
Cell[142344, 3112, 821, 11, 968, "Subsubsection"],
Cell[143168, 3125, 7799, 166, 4401, "Code"],
Cell[150970, 3293, 89, 2, 968, "Subsubsection"],
Cell[151062, 3297, 1846, 36, 1031, "Subsubsection"],
Cell[152911, 3335, 2454, 46, 1079, "Subsubsection"],
Cell[155368, 3383, 6032, 123, 4330, "Subsubtitle"],
Cell[161403, 3508, 771, 11, 968, "Subsubsection"],
Cell[162177, 3521, 6540, 148, 4401, "Code"],
Cell[168720, 3671, 44, 1, 71, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[168801, 3677, 2831, 66, 93, "Subsubtitle"],
Cell[171635, 3745, 1747, 38, 702, "Subsubsection"],
Cell[173385, 3785, 1800, 38, 551, "Subsubsection"],
Cell[175188, 3825, 3449, 69, 551, "Subsubsection"],
Cell[178640, 3896, 4547, 95, 1300, "Subsubtitle"],
Cell[183190, 3993, 819, 11, 495, "Subsubsection"],
Cell[184012, 4006, 5279, 129, 1882, "Code"],
Cell[189294, 4137, 89, 2, 495, "Subsubsection"],
Cell[189386, 4141, 1259, 21, 527, "Subsubsection"],
Cell[190648, 4164, 3656, 74, 551, "Subsubsection"],
Cell[194307, 4240, 6705, 147, 2692, "Subsubtitle"],
Cell[201015, 4389, 819, 11, 495, "Subsubsection"],
Cell[201837, 4402, 7265, 184, 2987, "Code"],
Cell[209105, 4588, 89, 2, 495, "Subsubsection"],
Cell[209197, 4592, 1512, 24, 527, "Subsubsection"],
Cell[210712, 4618, 3871, 77, 551, "Subsubsection"],
Cell[214586, 4697, 6854, 148, 2692, "Subsubtitle"],
Cell[221443, 4847, 872, 12, 495, "Subsubsection"],
Cell[222318, 4861, 7514, 188, 2987, "Code"],
Cell[229835, 5051, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[229916, 5057, 3094, 74, 132, "Subsubtitle"],
Cell[233013, 5133, 1784, 35, 125, "Subsubsection"],
Cell[234800, 5170, 3387, 65, 104, "Subsubsection"],
Cell[238190, 5237, 4630, 95, 324, "Subsubtitle"],
Cell[242823, 5334, 872, 12, 93, "Subsubsection"],
Cell[243698, 5348, 5294, 124, 351, "Code"],
Cell[248995, 5474, 89, 2, 93, "Subsubsection"],
Cell[249087, 5478, 1528, 26, 99, "Subsubsection"],
Cell[250618, 5506, 3424, 65, 104, "Subsubsection"],
Cell[254045, 5573, 5945, 130, 482, "Subsubtitle"],
Cell[259993, 5705, 872, 12, 93, "Subsubsection"],
Cell[260868, 5719, 6594, 162, 419, "Code"],
Cell[267465, 5883, 89, 2, 93, "Subsubsection"],
Cell[267557, 5887, 1860, 36, 99, "Subsubsection"],
Cell[269420, 5925, 3437, 67, 104, "Subsubsection"],
Cell[272860, 5994, 4900, 101, 324, "Subsubtitle"],
Cell[277763, 6097, 821, 11, 93, "Subsubsection"],
Cell[278587, 6110, 5521, 131, 351, "Code"],
Cell[284111, 6243, 89, 2, 93, "Subsubsection"],
Cell[284203, 6247, 1566, 27, 99, "Subsubsection"],
Cell[285772, 6276, 3407, 65, 104, "Subsubsection"],
Cell[289182, 6343, 5858, 133, 488, "Subsubtitle"],
Cell[295043, 6478, 821, 11, 93, "Subsubsection"],
Cell[295867, 6491, 6714, 168, 419, "Code"],
Cell[302584, 6661, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[302665, 6667, 3495, 76, 88, "Subsubtitle"],
Cell[306163, 6745, 1820, 36, 475, "Subsubsection"],
Cell[307986, 6783, 2942, 52, 354, "Subsubsection"],
Cell[310931, 6837, 4772, 96, 1546, "Subsubtitle"],
Cell[315706, 6935, 821, 11, 354, "Subsubsection"],
Cell[316530, 6948, 4304, 90, 1079, "Code"],
Cell[320837, 7040, 4301, 97, 1187, "Code"],
Cell[325141, 7139, 89, 2, 354, "Subsubsection"],
Cell[325233, 7143, 1485, 25, 377, "Subsubsection"],
Cell[326721, 7170, 3149, 57, 354, "Subsubsection"],
Cell[329873, 7229, 7246, 149, 2164, "Subsubtitle"],
Cell[337122, 7380, 821, 11, 354, "Subsubsection"],
Cell[337946, 7393, 5082, 121, 1605, "Code"],
Cell[343031, 7516, 5845, 144, 1712, "Code"],
Cell[348879, 7662, 89, 2, 354, "Subsubsection"],
Cell[348971, 7666, 1565, 26, 377, "Subsubsection"],
Cell[350539, 7694, 3234, 59, 354, "Subsubsection"],
Cell[353776, 7755, 5595, 124, 2164, "Subsubtitle"],
Cell[359374, 7881, 821, 11, 354, "Subsubsection"],
Cell[360198, 7894, 5330, 121, 1605, "Code"],
Cell[365531, 8017, 5685, 138, 1712, "Code"],
Cell[371219, 8157, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[371300, 8163, 3166, 71, 88, "Subsubtitle"],
Cell[374469, 8236, 1383, 19, 968, "Subsubsection"],
Cell[375855, 8257, 3859, 66, 968, "Subsubsection"],
Cell[379717, 8325, 8079, 178, 6669, "Subsubtitle"],
Cell[387799, 8505, 819, 11, 968, "Subsubsection"],
Cell[388621, 8518, 10532, 234, 6572, "Code"],
Cell[399156, 8754, 89, 2, 968, "Subsubsection"],
Cell[399248, 8758, 1368, 19, 664, "Subsubsection"],
Cell[400619, 8779, 3556, 64, 1079, "Subsubsection"],
Cell[404178, 8845, 6943, 154, 8166, "Subsubtitle"],
Cell[411124, 9001, 771, 11, 968, "Subsubsection"],
Cell[411898, 9014, 8767, 205, 6572, "Code"],
Cell[420668, 9221, 89, 2, 968, "Subsubsection"],
Cell[420760, 9225, 1639, 23, 664, "Subsubsection"],
Cell[422402, 9250, 1855, 30, 1031, "Subsubsection"],
Cell[424260, 9282, 3443, 65, 1079, "Subsubsection"],
Cell[427706, 9349, 6948, 161, 8152, "Subsubtitle"],
Cell[434657, 9512, 870, 12, 968, "Subsubsection"],
Cell[435530, 9526, 9413, 219, 6572, "Code"],
Cell[444946, 9747, 89, 2, 968, "Subsubsection"],
Cell[445038, 9751, 1762, 24, 664, "Subsubsection"],
Cell[446803, 9777, 1909, 31, 1031, "Subsubsection"],
Cell[448715, 9810, 3441, 63, 1079, "Subsubsection"],
Cell[452159, 9875, 7116, 164, 8152, "Subsubtitle"],
Cell[459278, 10041, 771, 11, 968, "Subsubsection"],
Cell[460052, 10054, 9298, 214, 6572, "Code"],
Cell[469353, 10270, 89, 2, 968, "Subsubsection"],
Cell[469445, 10274, 1176, 16, 664, "Subsubsection"],
Cell[470624, 10292, 4079, 74, 1079, "Subsubsection"],
Cell[474706, 10368, 6470, 147, 8229, "Subsubtitle"],
Cell[481179, 10517, 771, 11, 968, "Subsubsection"],
Cell[481953, 10530, 9029, 205, 6572, "Code"],
Cell[490985, 10737, 89, 2, 968, "Subsubsection"],
Cell[491077, 10741, 1353, 18, 664, "Subsubsection"],
Cell[492433, 10761, 2986, 53, 968, "Subsubsection"],
Cell[495422, 10816, 6605, 158, 6724, "Subsubtitle"],
Cell[502030, 10976, 771, 11, 968, "Subsubsection"],
Cell[502804, 10989, 8724, 203, 6572, "Code"],
Cell[511531, 11194, 44, 1, 71, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
